/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt_c722md.core.runtime;

import java.util.Random;
import org.jacoco.agent.rt_c722md.core.data.ExecutionDataStore;
import org.jacoco.agent.rt_c722md.core.data.IExecutionDataVisitor;
import org.jacoco.agent.rt_c722md.core.data.ISessionInfoVisitor;
import org.jacoco.agent.rt_c722md.core.data.SessionInfo;
import org.jacoco.agent.rt_c722md.core.runtime.ExecutionDataAccess;
import org.jacoco.agent.rt_c722md.core.runtime.IRuntime;

public abstract class AbstractRuntime
implements IRuntime {
    protected final ExecutionDataStore store = new ExecutionDataStore();
    protected final ExecutionDataAccess access = new ExecutionDataAccess(this.store);
    private long startTimeStamp;
    private String sessionId = this.generateSessionId();

    protected AbstractRuntime() {
    }

    protected final void setStartTimeStamp() {
        this.startTimeStamp = System.currentTimeMillis();
    }

    public void setSessionId(String id) {
        this.sessionId = id;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void collect(IExecutionDataVisitor executionDataVisitor, ISessionInfoVisitor sessionInfoVisitor, boolean reset) {
        ExecutionDataStore executionDataStore = this.store;
        synchronized (executionDataStore) {
            if (sessionInfoVisitor != null) {
                SessionInfo info = new SessionInfo(this.sessionId, this.startTimeStamp, System.currentTimeMillis());
                sessionInfoVisitor.visitSessionInfo(info);
            }
            this.store.accept(executionDataVisitor);
            if (reset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        ExecutionDataStore executionDataStore = this.store;
        synchronized (executionDataStore) {
            this.store.reset();
            this.setStartTimeStamp();
        }
    }

    private String generateSessionId() {
        return Integer.toHexString(new Random().nextInt());
    }
}

