/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.search;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import org.eclipse.rse.services.clientserver.search.ISystemSearchMatcher;
import org.eclipse.rse.services.clientserver.search.SystemNonRegexMatcher;
import org.eclipse.rse.services.clientserver.search.SystemSearchUtil;

public class SystemSearchFileNameMatcher
implements ISystemSearchMatcher {
    private String fileNamesString;
    private boolean isRegex;
    private List nonRegexMatchers;
    private Pattern pattern;

    public SystemSearchFileNameMatcher(String fileNamesString, boolean isCaseSensitive, boolean isRegex) {
        block7: {
            if (fileNamesString == null) {
                throw new NullPointerException();
            }
            this.fileNamesString = fileNamesString;
            this.isRegex = isRegex;
            if (isRegex) {
                try {
                    if (isCaseSensitive) {
                        this.pattern = Pattern.compile(fileNamesString);
                        break block7;
                    }
                    this.pattern = Pattern.compile(fileNamesString, 2);
                }
                catch (Exception exception) {}
            } else {
                this.nonRegexMatchers = new Vector();
                Set names = SystemSearchUtil.getInstance().typesStringToSet(fileNamesString);
                Iterator iter = names.iterator();
                while (iter.hasNext()) {
                    String name = (String)iter.next();
                    SystemNonRegexMatcher nonRegexMatcher = new SystemNonRegexMatcher(name, !isCaseSensitive, false);
                    this.nonRegexMatchers.add(nonRegexMatcher);
                }
            }
        }
    }

    public boolean isFileNamesStringEmpty() {
        return this.fileNamesString.length() == 0;
    }

    public boolean isFileNamesStringAsterisk() {
        return this.fileNamesString.equals("*");
    }

    public boolean matches(String input) {
        if (this.isFileNamesStringEmpty()) {
            return true;
        }
        if (this.isRegex) {
            return this.pattern.matcher(input).find();
        }
        Iterator iter = this.nonRegexMatchers.iterator();
        while (iter.hasNext()) {
            SystemNonRegexMatcher matcher = (SystemNonRegexMatcher)iter.next();
            if (!matcher.match(input)) continue;
            return true;
        }
        return false;
    }
}

