/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt_c722md.core.internal.instr;

import org.jacoco.agent.rt_c722md.asm.Label;
import org.jacoco.agent.rt_c722md.asm.MethodAdapter;
import org.jacoco.agent.rt_c722md.asm.MethodVisitor;
import org.jacoco.agent.rt_c722md.asm.Type;

class ProbeVariableInserter
extends MethodAdapter {
    protected final int variable;
    private final int variableIdx;
    private boolean firstFrame = true;

    ProbeVariableInserter(int access, String desc, MethodVisitor mv) {
        super(mv);
        int idx;
        int pos = idx = (8 & access) == 0 ? 1 : 0;
        for (Type t : Type.getArgumentTypes(desc)) {
            ++idx;
            pos += t.getSize();
        }
        this.variableIdx = idx;
        this.variable = pos;
    }

    public void visitVarInsn(int opcode, int var) {
        this.mv.visitVarInsn(opcode, this.map(var));
    }

    public void visitIincInsn(int var, int increment) {
        this.mv.visitIincInsn(this.map(var), increment);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.mv.visitMaxs(maxStack, maxLocals + 1);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.mv.visitLocalVariable(name, desc, signature, start, end, this.map(index));
    }

    private int map(int var) {
        if (var < this.variable) {
            return var;
        }
        return var + 1;
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        if (type != -1) {
            throw new IllegalStateException("ClassReader.accept() should be called with EXPAND_FRAMES flag");
        }
        if (this.firstFrame) {
            this.mv.visitFrame(type, nLocal, local, nStack, stack);
            this.firstFrame = false;
            return;
        }
        Object[] newLocal = new Object[nLocal + 1];
        for (int i = 0; i <= local.length; ++i) {
            newLocal[i] = i < this.variableIdx ? local[i] : (i > this.variableIdx ? local[i - 1] : "[Z");
        }
        this.mv.visitFrame(type, nLocal + 1, newLocal, nStack, stack);
    }
}

