/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.tests.framework.scripting;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.internal.tests.framework.scripting.ScriptContext;
import org.eclipse.swt.graphics.ImageData;

public class ConsoleContext
extends ScriptContext {
    private PrintWriter transcript;

    public ConsoleContext(PrintStream out, URL home) {
        super(home);
        this.transcript = new PrintWriter(out);
    }

    public void show(String imageName) {
        ImageDescriptor descriptor;
        ImageData data;
        this.log("showing " + imageName);
        String message = "image not found";
        URL imageURL = this.getResourceURL(imageName);
        if (imageURL != null && (data = (descriptor = ImageDescriptor.createFromURL((URL)imageURL)).getImageData()) != null) {
            String type = "Unknown";
            switch (data.type) {
                case 2: {
                    type = "GIF";
                    break;
                }
                case 4: {
                    type = "JPEG";
                    break;
                }
                case 5: {
                    type = "PNG";
                    break;
                }
                default: {
                    type = "Other";
                }
            }
            message = String.valueOf(type) + "(" + Integer.toString(data.width) + " x " + Integer.toString(data.height) + ")";
        }
        this.log(message);
    }

    public void tell(String text) {
        this.log(text);
    }

    public void pause(String text) {
        if (text.length() == 0) {
            text = "pausing";
        }
        this.log(text);
    }

    private void log(String message) {
        this.transcript.println(message);
        this.transcript.flush();
    }
}

