/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import java.util.HashMap;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.ui.SystemPreferencesManager;
import org.eclipse.rse.ui.view.ISystemTableViewColumnManager;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SystemTableViewColumnManager
implements ISystemTableViewColumnManager {
    private Viewer _viewer;
    protected HashMap _descriptorCache;

    public SystemTableViewColumnManager(Viewer viewer) {
        this._viewer = viewer;
        this._descriptorCache = new HashMap();
    }

    protected IPropertyDescriptor[] getCachedDescriptors(ISystemViewElementAdapter adapter) {
        Object descriptors = this._descriptorCache.get(adapter);
        if (descriptors != null && descriptors instanceof IPropertyDescriptor[]) {
            return (IPropertyDescriptor[])descriptors;
        }
        return null;
    }

    protected void putCachedDescriptors(ISystemViewElementAdapter adapter, IPropertyDescriptor[] descriptors) {
        this._descriptorCache.put(adapter, descriptors);
    }

    public void setCustomDescriptors(ISystemViewElementAdapter adapter, IPropertyDescriptor[] descriptors) {
        this.putCachedDescriptors(adapter, descriptors);
        String historyKey = this.getHistoryKey(adapter);
        String[] history = new String[descriptors.length];
        int i = 0;
        while (i < descriptors.length) {
            history[i] = descriptors[i].getId().toString();
            ++i;
        }
        SystemPreferencesManager.setWidgetHistory(historyKey, history);
    }

    public IPropertyDescriptor[] getVisibleDescriptors(ISystemViewElementAdapter adapter) {
        if (adapter != null) {
            IPropertyDescriptor[] descriptors = this.getCachedDescriptors(adapter);
            if (descriptors == null) {
                return this.getCustomDescriptors(adapter);
            }
            return descriptors;
        }
        return new IPropertyDescriptor[0];
    }

    private String getHistoryKey(ISystemViewElementAdapter adapter) {
        String adapterName = adapter.getClass().getName();
        String viewName = this._viewer.getClass().getName();
        return String.valueOf(adapterName) + ":" + viewName;
    }

    protected IPropertyDescriptor[] getCustomDescriptors(ISystemViewElementAdapter adapter) {
        IPropertyDescriptor[] uniqueDescriptors = adapter.getUniquePropertyDescriptors();
        String historyKey = this.getHistoryKey(adapter);
        String[] history = SystemPreferencesManager.getWidgetHistory(historyKey);
        if (history != null && history.length > 0) {
            int len = history.length;
            if (uniqueDescriptors != null && uniqueDescriptors.length < len) {
                len = uniqueDescriptors.length;
            }
            IPropertyDescriptor[] customDescriptors = new IPropertyDescriptor[len];
            if (uniqueDescriptors != null) {
                int i = 0;
                while (i < len) {
                    String propertyName = history[i];
                    boolean found = false;
                    int d = 0;
                    while (d < uniqueDescriptors.length && !found) {
                        IPropertyDescriptor descriptor = uniqueDescriptors[d];
                        if (propertyName.equals(descriptor.getId().toString())) {
                            customDescriptors[i] = descriptor;
                            found = true;
                        }
                        ++d;
                    }
                    if (!found) {
                        this.setCustomDescriptors(adapter, uniqueDescriptors);
                        return uniqueDescriptors;
                    }
                    ++i;
                }
            }
            return customDescriptors;
        }
        this.setCustomDescriptors(adapter, uniqueDescriptors);
        return uniqueDescriptors;
    }
}

