/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.discovery.wizard;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm.discovery.protocol.ProtocolFactory;
import org.eclipse.tm.discovery.transport.TransportFactory;
import org.eclipse.tm.internal.discovery.wizard.Messages;
import org.eclipse.ui.PlatformUI;

public class ServiceDiscoveryWizardMainPage
extends WizardPage {
    private int timeOut = 500;
    private Combo queryCombo;
    private Combo transportCombo;
    private Combo protocolCombo;
    private Text addressText;
    private Text timeOutText;
    private Button multicastButton;
    private String tempAddress;

    public ServiceDiscoveryWizardMainPage() {
        super("wizardPage1");
        this.setTitle(Messages.getString("ServiceDiscoveryWizardMainPage.WizardPageTitle"));
        this.setDescription(Messages.getString("ServiceDiscoveryWizardMainPage.WizardPageDescription"));
        this.setErrorMessage(Messages.getString("ServiceDiscoveryWizardMainPage.ProvideAddressError"));
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        comp.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 1;
        data.grabExcessVerticalSpace = false;
        comp.setLayoutData((Object)data);
        new Label(comp, 0).setText(Messages.getString("ServiceDiscoveryWizardMainPage.AddressLabel"));
        this.addressText = new Text(comp, 2116);
        this.addressText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (((Text)e.getSource()).getText().equals("")) {
                    ServiceDiscoveryWizardMainPage.this.setErrorMessage(Messages.getString("ServiceDiscoveryWizardMainPage.ProvideAddressError"));
                    ServiceDiscoveryWizardMainPage.this.setPageComplete(false);
                } else {
                    ServiceDiscoveryWizardMainPage.this.setErrorMessage(null);
                    ServiceDiscoveryWizardMainPage.this.setPageComplete(true);
                }
            }
        });
        this.addressText.setLayoutData((Object)data);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.addressText, "org.eclipse.tm.discovery.wizard.address");
        Composite comp2 = new Composite(comp, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 2;
        comp2.setLayout((Layout)layout2);
        this.multicastButton = new Button(comp2, 32);
        this.multicastButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Object src = e.getSource();
                if (((Button)src).getSelection()) {
                    String multicastAddress = null;
                    try {
                        multicastAddress = ProtocolFactory.getMulticastAddress((String)ServiceDiscoveryWizardMainPage.this.protocolCombo.getText(), (String)ServiceDiscoveryWizardMainPage.this.transportCombo.getText());
                    }
                    catch (CoreException coreException) {}
                    if (multicastAddress != null) {
                        ServiceDiscoveryWizardMainPage.this.tempAddress = ServiceDiscoveryWizardMainPage.this.addressText.getText();
                        ServiceDiscoveryWizardMainPage.this.addressText.setText(multicastAddress);
                    } else {
                        ((Button)src).setSelection(false);
                    }
                } else if (ServiceDiscoveryWizardMainPage.this.tempAddress != null) {
                    ServiceDiscoveryWizardMainPage.this.addressText.setText(ServiceDiscoveryWizardMainPage.this.tempAddress);
                }
            }
        });
        new Label(comp2, 0).setText(Messages.getString("ServiceDiscoveryWizardMainPage.MuticastAddressLabel0"));
        new Label(comp, 0).setText(Messages.getString("ServiceDiscoveryWizardMainPage.TransportLabel"));
        this.transportCombo = new Combo(comp, 8);
        this.transportCombo.setItems(TransportFactory.getTransportList());
        this.transportCombo.select(0);
        this.transportCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (ServiceDiscoveryWizardMainPage.this.multicastButton.getSelection()) {
                    String multicastAddress = null;
                    try {
                        multicastAddress = ProtocolFactory.getMulticastAddress((String)ServiceDiscoveryWizardMainPage.this.protocolCombo.getText(), (String)ServiceDiscoveryWizardMainPage.this.transportCombo.getText());
                    }
                    catch (CoreException coreException) {}
                    if (multicastAddress != null) {
                        ServiceDiscoveryWizardMainPage.this.tempAddress = ServiceDiscoveryWizardMainPage.this.addressText.getText();
                        ServiceDiscoveryWizardMainPage.this.addressText.setText(multicastAddress);
                    }
                }
            }
        });
        this.transportCombo.setLayoutData((Object)data);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.transportCombo, "org.eclipse.tm.discovery.wizard.transport");
        new Label(comp, 0).setText(Messages.getString("ServiceDiscoveryWizardMainPage.ProtocolLabel"));
        this.protocolCombo = new Combo(comp, 8);
        this.protocolCombo.setItems(ProtocolFactory.getProtocolList());
        this.protocolCombo.select(0);
        this.protocolCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent event) {
                String selectedProtocol = ((Combo)event.getSource()).getText();
                String[] queries = new String[]{};
                try {
                    queries = ProtocolFactory.getQueryList((String)selectedProtocol);
                }
                catch (CoreException coreException) {}
                ServiceDiscoveryWizardMainPage.this.queryCombo.removeAll();
                ServiceDiscoveryWizardMainPage.this.queryCombo.setItems(queries);
                ServiceDiscoveryWizardMainPage.this.queryCombo.select(0);
                if (ServiceDiscoveryWizardMainPage.this.multicastButton.getSelection()) {
                    String multicastAddress = null;
                    try {
                        multicastAddress = ProtocolFactory.getMulticastAddress((String)ServiceDiscoveryWizardMainPage.this.protocolCombo.getText(), (String)ServiceDiscoveryWizardMainPage.this.transportCombo.getText());
                    }
                    catch (CoreException coreException) {}
                    if (multicastAddress != null) {
                        ServiceDiscoveryWizardMainPage.this.tempAddress = ServiceDiscoveryWizardMainPage.this.addressText.getText();
                        ServiceDiscoveryWizardMainPage.this.addressText.setText(multicastAddress);
                    }
                }
            }
        });
        this.protocolCombo.setLayoutData((Object)data);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.protocolCombo, "org.eclipse.tm.discovery.wizard.protocol");
        new Label(comp, 0).setText(Messages.getString("ServiceDiscoveryWizardMainPage.DiscoveryQueryLabel"));
        this.queryCombo = new Combo(comp, 0);
        String[] queries = new String[]{};
        try {
            queries = ProtocolFactory.getQueryList((String)this.protocolCombo.getText());
        }
        catch (CoreException coreException) {}
        int i = 0;
        while (i < queries.length) {
            this.queryCombo.add(queries[i]);
            ++i;
        }
        this.queryCombo.select(0);
        this.queryCombo.setLayoutData((Object)data);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.queryCombo, "org.eclipse.tm.discovery.wizard.query");
        new Label(comp, 0).setText(Messages.getString("ServiceDiscoveryWizardMainPage.TimeOutLabel"));
        this.timeOutText = new Text(comp, 2116);
        this.timeOutText.setText(Messages.getString("ServiceDiscoveryWizardMainPage.TimeOutValue"));
        this.timeOutText.redraw();
        this.timeOutText.setLayoutData((Object)data);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.timeOutText, "org.eclipse.tm.discovery.wizard.timeout");
        this.setPageComplete(false);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.tm.discovery.wizard.general");
    }

    public String getQuery() {
        return this.queryCombo.getText();
    }

    public String getAddress() {
        return this.addressText.getText();
    }

    public String getTransport() {
        return this.transportCombo.getText();
    }

    public String getProtocol() {
        return this.protocolCombo.getText();
    }

    public int getTimeOut() {
        try {
            this.timeOut = Integer.parseInt(this.timeOutText.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {}
        return this.timeOut;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }
}

