/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.subsystems.files;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.efs.RSEFileSystem;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.shells.core.model.SimpleCommandOperation;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IShellServiceSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.ShellServiceSubSystem;
import org.eclipse.rse.tests.subsystems.files.FileServiceBaseTest;

public class RSEFileStoreTest
extends FileServiceBaseTest {
    private String fPropertiesFileName;
    public static String fDefaultPropertiesFile = null;
    private IRemoteFile fHomeDirectory;
    private String fTestStorePath;
    private IFileStore fTestStore;
    private InputStream fIS;
    private OutputStream fOS;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public RSEFileStoreTest(String name) {
        this(name, fDefaultPropertiesFile);
    }

    public RSEFileStoreTest(String name, String propertiesFileName) {
        super(name);
        this.fPropertiesFileName = propertiesFileName;
        if (propertiesFileName != null) {
            int idx = propertiesFileName.indexOf("Connection.properties");
            String targetName = propertiesFileName.substring(0, idx);
            this.setTargetName(targetName);
        }
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.RSEFileStoreTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String baseName = clazz.getName();
        TestSuite suite = new TestSuite(baseName);
        String[] stringArray = new String[2];
        stringArray[1] = "local";
        String[] connTypes = stringArray;
        int i = 0;
        while (i < connTypes.length) {
            String suiteName = connTypes[i] == null ? "EFS" : connTypes[i];
            String propFileName = connTypes[i] == null ? null : String.valueOf(connTypes[i]) + "Connection.properties";
            TestSuite subSuite = new TestSuite(String.valueOf(baseName) + "." + suiteName);
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.rse.tests.subsystems.files.RSEFileStoreTest");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Method[] m = clazz2.getMethods();
            int j = 0;
            while (j < m.length) {
                String testName = m[j].getName();
                if (testName.startsWith("test")) {
                    subSuite.addTest((Test)new RSEFileStoreTest(testName, propFileName));
                }
                ++j;
            }
            suite.addTest((Test)subSuite);
            ++i;
        }
        return suite;
    }

    protected IShellServiceSubSystem getShellServiceSubSystem() {
        if (this.fPropertiesFileName == null) {
            return null;
        }
        IHost host = this.getHost(this.fPropertiesFileName);
        ISystemRegistry iSystemRegistry = RSECorePlugin.getTheSystemRegistry();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.rse.services.shells.IShellService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISubSystem[] ss = iSystemRegistry.getServiceSubSystems(host, (Class)clazz);
        int i = 0;
        while (i < ss.length) {
            if (ss[i] instanceof ShellServiceSubSystem) {
                return (ShellServiceSubSystem)ss[i];
            }
            ++i;
        }
        return null;
    }

    public void setUp() throws Exception {
        super.setUp();
        if (this.fPropertiesFileName == null) {
            String homePath = System.getProperty("user.home");
            Path testPath = new Path(String.valueOf(homePath) + "/rseTest" + System.currentTimeMillis());
            this.fTestStorePath = testPath.toOSString();
            this.fTestStore = EFS.getLocalFileSystem().getStore((IPath)testPath);
            this.fTestStore.mkdir(0, this.getDefaultProgressMonitor());
        } else {
            IHost host = this.getHost(this.fPropertiesFileName);
            IRemoteFileSubSystem fss = RemoteFileUtility.getFileSubSystem((IHost)host);
            fss.checkIsConnected(this.getDefaultProgressMonitor());
            this.fHomeDirectory = fss.getRemoteFileObject(".", this.getDefaultProgressMonitor());
            Path testPath = new Path(String.valueOf(this.fHomeDirectory.getAbsolutePath()) + "/rseTest" + System.currentTimeMillis());
            this.fTestStorePath = testPath.toString();
            URI testURI = RSEFileSystem.getURIFor((String)host.getHostName(), (String)this.fTestStorePath);
            this.fTestStore = RSEFileSystem.getInstance().getStore(testURI);
            this.fTestStore.mkdir(0, this.getDefaultProgressMonitor());
        }
    }

    public void tearDown() throws Exception {
        if (this.fIS != null) {
            try {
                this.fIS.close();
            }
            catch (IOException e) {
                System.err.println("Exception in tearDown.closeInputStream:");
                e.printStackTrace();
            }
        }
        if (this.fOS != null) {
            try {
                this.fOS.close();
            }
            catch (IOException e) {
                System.err.println("Exception in tearDown.closeOutputStream:");
                e.printStackTrace();
            }
        }
        try {
            this.fTestStore.delete(0, this.getDefaultProgressMonitor());
        }
        catch (CoreException ce) {
            System.err.println("Exception in tearDown.deleteTestStore:");
            ce.printStackTrace();
        }
        super.tearDown();
    }

    protected IFileStore createFile(String name) throws Exception {
        IFileStore store = this.fTestStore.getChild(name);
        this.fOS = store.openOutputStream(0, this.getDefaultProgressMonitor());
        this.fOS.write(name.getBytes());
        this.fOS.flush();
        this.fOS.close();
        this.fOS = null;
        return store;
    }

    public void testRecursiveGetParent() {
        if (this.isTestDisabled()) {
            return;
        }
        IFileStore store = this.fTestStore;
        String homePath = store.toURI().getPath();
        RSEFileStoreTest.assertTrue((String)("exists: " + store), (boolean)store.fetchInfo().exists());
        IFileStore newStore = store.getParent();
        while (newStore != null && newStore.isParentOf(store)) {
            RSEFileStoreTest.assertTrue((String)("exists: " + newStore), (boolean)newStore.fetchInfo().exists());
            store = newStore;
        }
        String newPath = store.toURI().getPath();
        RSEFileStoreTest.assertTrue((String)("newPath not empty: " + newPath), (newPath.length() > 0 ? 1 : 0) != 0);
        RSEFileStoreTest.assertTrue((String)("newPath < homePath " + homePath), (newPath.length() < homePath.length() ? 1 : 0) != 0);
    }

    public void testAppendOutputStream() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        IFileStore f = this.createFile("foo");
        this.fOS = f.openOutputStream(1, this.getDefaultProgressMonitor());
        this.fOS.write("bar".getBytes());
        this.fOS.flush();
        this.fOS.close();
        this.fOS = null;
        this.fIS = f.openInputStream(0, this.getDefaultProgressMonitor());
        byte[] b = "foobar".getBytes();
        int i = 0;
        while (i < b.length) {
            RSEFileStoreTest.assertTrue((String)("Reading byte " + i), (b[i] == this.fIS.read() ? 1 : 0) != 0);
            ++i;
        }
        RSEFileStoreTest.assertTrue((String)"EOF", (this.fIS.read() == -1 ? 1 : 0) != 0);
        this.fIS.close();
        this.fIS = null;
    }

    public void testPutInfo() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        IFileInfo testInfo = this.fTestStore.fetchInfo();
        RSEFileStoreTest.assertTrue((String)"1.1", (boolean)testInfo.exists());
        RSEFileStoreTest.assertTrue((String)"1.2", (boolean)testInfo.isDirectory());
        RSEFileStoreTest.assertTrue((String)"1.3", (testInfo.getLength() == 0L ? 1 : 0) != 0);
        long parentModified = testInfo.getLastModified();
        IFileStore f = this.createFile("testReadOnly.txt");
        IFileInfo info = f.fetchInfo();
        RSEFileStoreTest.assertFalse((String)"2.1", (boolean)info.isDirectory());
        RSEFileStoreTest.assertFalse((String)"2.2", (boolean)info.getAttribute(2));
        RSEFileStoreTest.assertTrue((String)"2.3", (info.getLastModified() >= parentModified ? 1 : 0) != 0);
        info.setLastModified(parentModified - 120000L);
        f.putInfo(info, 2048, this.getDefaultProgressMonitor());
        info = f.fetchInfo();
        RSEFileStoreTest.assertTrue((String)"2.4", (info.getLastModified() < parentModified ? 1 : 0) != 0);
        info.setAttribute(2, true);
        f.putInfo(info, 1024, this.getDefaultProgressMonitor());
        info = f.fetchInfo();
        RSEFileStoreTest.assertTrue((String)"2.5", (boolean)info.getAttribute(2));
        info.setLastModified(parentModified + 120000L);
        RSEFileStoreTest.assertTrue((String)"2.6.1", (info.getLastModified() > parentModified ? 1 : 0) != 0);
        try {
            f.putInfo(info, 2048, this.getDefaultProgressMonitor());
        }
        catch (CoreException ce) {
            System.out.println("OK: Exception on putInfo to read-only: " + ce.getLocalizedMessage());
        }
        info = f.fetchInfo();
    }

    public void testDeleteSpecialCases() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        String testFileName = "noPerm.txt";
        boolean exceptionThrown = false;
        IFileStore store = this.createFile(testFileName);
        IFileInfo info = store.fetchInfo(0, this.getDefaultProgressMonitor());
        info.setAttribute(2, true);
        store.putInfo(info, 1024, this.getDefaultProgressMonitor());
        info = this.fTestStore.fetchInfo();
        info.setAttribute(2, true);
        info.setAttribute(4, false);
        this.fTestStore.putInfo(info, 1024, this.getDefaultProgressMonitor());
        try {
            store.delete(0, this.getDefaultProgressMonitor());
        }
        catch (CoreException ce) {
            exceptionThrown = true;
            System.out.println("Good! " + (Object)((Object)ce));
            RSEFileStoreTest.assertTrue((String)"1.1.1", (ce.getStatus().getCode() == 273 ? 1 : 0) != 0);
        }
        if (!(fDefaultPropertiesFile == null && File.separatorChar == '\\' || this.fHomeDirectory != null && this.fHomeDirectory.getSeparatorChar() == '\\')) {
            RSEFileStoreTest.assertTrue((String)"1.1", (boolean)exceptionThrown);
            IFileInfo info2 = store.fetchInfo();
            RSEFileStoreTest.assertTrue((boolean)info2.exists());
        }
        info.setAttribute(2, false);
        info.setAttribute(4, true);
        this.fTestStore.putInfo(info, 1024, this.getDefaultProgressMonitor());
        store.delete(0, this.getDefaultProgressMonitor());
        info = store.fetchInfo(0, this.getDefaultProgressMonitor());
        RSEFileStoreTest.assertTrue((String)"1.2", (!info.exists() ? 1 : 0) != 0);
        if (this.fHomeDirectory != null && this.fHomeDirectory.getSeparatorChar() == '/' && this.fHomeDirectory.getParentRemoteFileSubSystem().isCaseSensitive()) {
            IShellServiceSubSystem rcmd = this.getShellServiceSubSystem();
            SimpleCommandOperation op = new SimpleCommandOperation((IRemoteCmdSubSystem)rcmd, this.fHomeDirectory, true);
            op.runCommand("ln -s notExisting2.txt \"" + this.fTestStorePath + "/" + testFileName + "\"", true);
            while (op.isActive()) {
                Thread.sleep(200L);
            }
            store.delete(0, this.getDefaultProgressMonitor());
            info = store.fetchInfo(0, this.getDefaultProgressMonitor());
            RSEFileStoreTest.assertTrue((String)"1.3", (!info.exists() ? 1 : 0) != 0);
            SimpleCommandOperation op2 = new SimpleCommandOperation((IRemoteCmdSubSystem)rcmd, this.fHomeDirectory, true);
            op2.runCommand("ln -s . \"" + this.fTestStorePath + "/" + testFileName + "\"", true);
            while (op2.isActive()) {
                Thread.sleep(200L);
            }
            store.delete(0, this.getDefaultProgressMonitor());
            info = store.fetchInfo(0, this.getDefaultProgressMonitor());
            RSEFileStoreTest.assertTrue((String)"1.4", (!info.exists() ? 1 : 0) != 0);
            store = this.createFile(testFileName);
            SimpleCommandOperation op3 = new SimpleCommandOperation((IRemoteCmdSubSystem)rcmd, this.fHomeDirectory, true);
            op3.runCommand("chmod 000 \"" + this.fTestStorePath + "\"", true);
            while (op3.isActive()) {
                Thread.sleep(200L);
            }
            exceptionThrown = false;
            try {
                store.delete(0, this.getDefaultProgressMonitor());
            }
            catch (CoreException ce) {
                exceptionThrown = true;
                System.out.println("Good! " + (Object)((Object)ce));
                RSEFileStoreTest.assertTrue((String)"1.5.1", (ce.getStatus().getCode() == 273 ? 1 : 0) != 0);
            }
            RSEFileStoreTest.assertTrue((String)"1.5", (boolean)exceptionThrown);
            exceptionThrown = false;
            try {
                info = store.fetchInfo(0, this.getDefaultProgressMonitor());
            }
            catch (CoreException ce) {
                exceptionThrown = true;
                System.out.println("Good! " + (Object)((Object)ce));
                RSEFileStoreTest.assertTrue((String)"1.6.1", (ce.getStatus().getCode() == 271 ? 1 : 0) != 0);
            }
            RSEFileStoreTest.assertTrue((String)"1.6", (boolean)exceptionThrown);
            SimpleCommandOperation op4 = new SimpleCommandOperation((IRemoteCmdSubSystem)rcmd, this.fHomeDirectory, true);
            op4.runCommand("chmod 777 \"" + this.fTestStorePath + "\"", true);
            while (op3.isActive()) {
                Thread.sleep(200L);
            }
            Thread.sleep(500L);
            info = store.fetchInfo();
            RSEFileStoreTest.assertTrue((boolean)info.exists());
        }
    }

    public void testModifyNonExisting() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        IFileStore store = this.fTestStore.getChild("nonExisting.txt");
        boolean exceptionThrown = false;
        IFileInfo info = store.fetchInfo(0, this.getDefaultProgressMonitor());
        RSEFileStoreTest.assertTrue((String)"1.1", (!info.exists() ? 1 : 0) != 0);
        store.delete(0, this.getDefaultProgressMonitor());
        info = store.fetchInfo(0, this.getDefaultProgressMonitor());
        RSEFileStoreTest.assertTrue((String)"1.2", (!info.exists() ? 1 : 0) != 0);
        exceptionThrown = false;
        try {
            info = new FileInfo();
            store.putInfo(info, 1024, this.getDefaultProgressMonitor());
        }
        catch (CoreException ce) {
            System.out.println("Good! putInfo attrib non-existing: " + ce.getLocalizedMessage());
            exceptionThrown = true;
            RSEFileStoreTest.assertTrue((String)"1.3.1", (ce.getStatus().getCode() == 269 ? 1 : 0) != 0);
        }
        RSEFileStoreTest.assertTrue((String)"1.3", (boolean)exceptionThrown);
        exceptionThrown = false;
        try {
            info = new FileInfo();
            store.putInfo(info, 2048, this.getDefaultProgressMonitor());
        }
        catch (CoreException ce) {
            System.out.println("Good! putInfo lastMod non-existing: " + ce.getLocalizedMessage());
            exceptionThrown = true;
            RSEFileStoreTest.assertTrue((String)"1.4.1", (ce.getStatus().getCode() == 269 ? 1 : 0) != 0);
        }
        RSEFileStoreTest.assertTrue((String)"1.4", (boolean)exceptionThrown);
        exceptionThrown = false;
        info = store.fetchInfo(0, this.getDefaultProgressMonitor());
        RSEFileStoreTest.assertTrue((String)"1.5", (!info.exists() ? 1 : 0) != 0);
        exceptionThrown = false;
        try {
            this.fIS = store.openInputStream(0, this.getDefaultProgressMonitor());
        }
        catch (CoreException ce) {
            System.out.println("Good! openInputStream non-existing: " + ce.getLocalizedMessage());
            exceptionThrown = true;
            int code = ce.getStatus().getCode();
            RSEFileStoreTest.assertTrue((String)"1.6.1", (code == 269 || code == 271 ? 1 : 0) != 0);
        }
        RSEFileStoreTest.assertTrue((String)"1.6", (boolean)exceptionThrown);
        exceptionThrown = false;
        info = store.fetchInfo(0, this.getDefaultProgressMonitor());
        RSEFileStoreTest.assertTrue((String)"1.7", (!info.exists() ? 1 : 0) != 0);
        this.fOS = store.openOutputStream(1, this.getDefaultProgressMonitor());
        this.fOS.write(97);
        this.fOS.close();
        this.fOS = null;
        info = store.fetchInfo(0, this.getDefaultProgressMonitor());
        RSEFileStoreTest.assertTrue((String)"1.8.1", (boolean)info.exists());
        RSEFileStoreTest.assertTrue((String)"1.8.2", (info.getLength() == 1L ? 1 : 0) != 0);
        this.fOS = store.openOutputStream(0, this.getDefaultProgressMonitor());
        this.fOS.write(98);
        this.fOS.close();
        this.fOS = null;
        info = store.fetchInfo(0, this.getDefaultProgressMonitor());
        RSEFileStoreTest.assertTrue((String)"1.9.1", (boolean)info.exists());
        RSEFileStoreTest.assertTrue((String)"1.9.2", (info.getLength() == 1L ? 1 : 0) != 0);
    }

    public void testModifyReadOnly() throws Exception {
        int code;
        if (this.isTestDisabled()) {
            return;
        }
        IFileStore store = this.createFile("readOnly.txt");
        IFileInfo info = store.fetchInfo();
        info.setAttribute(2, true);
        store.putInfo(info, 1024, this.getDefaultProgressMonitor());
        boolean exceptionThrown = false;
        try {
            this.fOS = store.openOutputStream(1, this.getDefaultProgressMonitor());
            this.fOS.write(97);
            this.fOS.close();
            this.fOS = null;
        }
        catch (CoreException ce) {
            System.out.println("Good! appendReadOnly: " + ce.getLocalizedMessage());
            exceptionThrown = true;
            code = ce.getStatus().getCode();
            RSEFileStoreTest.assertTrue((String)"1.1.1", (code == 272 ? 1 : 0) != 0);
            RSEFileStoreTest.assertTrue((this.fOS == null ? 1 : 0) != 0);
        }
        RSEFileStoreTest.assertTrue((String)"1.1", (boolean)exceptionThrown);
        info.setAttribute(2, false);
        store.putInfo(info, 1024, this.getDefaultProgressMonitor());
        this.fOS = store.openOutputStream(1, this.getDefaultProgressMonitor());
        this.fOS.write(97);
        this.fOS.flush();
        info.setAttribute(2, true);
        exceptionThrown = false;
        try {
            store.putInfo(info, 1024, this.getDefaultProgressMonitor());
        }
        catch (CoreException ce) {
            System.out.println("Good! setOpenFileReadOnly: " + ce.getLocalizedMessage());
            code = ce.getStatus().getCode();
            RSEFileStoreTest.assertTrue((String)"2.1", (code == 272 ? 1 : 0) != 0);
        }
        if (!exceptionThrown) {
            info = store.fetchInfo();
            RSEFileStoreTest.assertTrue((String)"2.2", (boolean)info.getAttribute(2));
        }
        this.fOS.write(98);
        this.fOS.flush();
        this.fOS.close();
        store.putInfo(info, 1024, this.getDefaultProgressMonitor());
    }

    public void testMakeDeleteTree() throws Exception {
        int code;
        if (this.isTestDisabled()) {
            return;
        }
        IFileStore treeStore = this.fTestStore.getChild("treeTest");
        treeStore.mkdir(4, this.getDefaultProgressMonitor());
        boolean exceptionThrown = false;
        IFileStore treeNegStore = this.createFile("treeNegTest");
        treeNegStore = this.fTestStore.getChild("treeNegTest");
        try {
            treeNegStore.mkdir(4, this.getDefaultProgressMonitor());
        }
        catch (CoreException ce) {
            System.out.println("Good! treeNegStore.mkdir: " + ce.getLocalizedMessage());
            exceptionThrown = true;
            int code2 = ce.getStatus().getCode();
            RSEFileStoreTest.assertTrue((String)"1.1", (code2 == 276 ? 1 : 0) != 0);
        }
        RSEFileStoreTest.assertTrue((String)"1.2", (boolean)exceptionThrown);
        exceptionThrown = false;
        IFileStore store = treeStore.getChild("foo").getChild("bar").getChild("baz");
        try {
            store.mkdir(4, this.getDefaultProgressMonitor());
        }
        catch (CoreException ce) {
            System.out.println("Good! mkdirsShallow: " + ce.getLocalizedMessage());
            exceptionThrown = true;
            code = ce.getStatus().getCode();
            RSEFileStoreTest.assertTrue((String)"2.1", (code == 272 ? 1 : 0) != 0);
        }
        RSEFileStoreTest.assertTrue((String)"2.2", (boolean)exceptionThrown);
        store.mkdir(0, this.getDefaultProgressMonitor());
        exceptionThrown = false;
        try {
            this.fIS = store.openInputStream(0, this.getDefaultProgressMonitor());
        }
        catch (CoreException ce) {
            System.out.println("Good! openInputStream on folder: " + ce.getLocalizedMessage());
            exceptionThrown = true;
            code = ce.getStatus().getCode();
            RSEFileStoreTest.assertTrue((String)"3.1", (code == 271 || code == 276 ? 1 : 0) != 0);
        }
        RSEFileStoreTest.assertTrue((String)"3.2", (boolean)exceptionThrown);
        exceptionThrown = false;
        try {
            this.fOS = store.openOutputStream(0, this.getDefaultProgressMonitor());
        }
        catch (CoreException ce) {
            System.out.println("Good! openOutputStream on folder: " + ce.getLocalizedMessage());
            exceptionThrown = true;
            code = ce.getStatus().getCode();
            RSEFileStoreTest.assertTrue((String)"4.1", (code == 272 || code == 276 ? 1 : 0) != 0);
        }
        RSEFileStoreTest.assertTrue((String)"4.2", (boolean)exceptionThrown);
        IFileStore child1 = store.getChild("readOnlyFile.txt");
        this.fOS = child1.openOutputStream(0, this.getDefaultProgressMonitor());
        this.fOS.write("foobar\nbaz\n".getBytes());
        this.fOS.flush();
        this.fOS.close();
        this.fOS = null;
        IFileInfo child1info = child1.fetchInfo();
        child1info.setAttribute(2, true);
        child1.putInfo(child1info, 1024, this.getDefaultProgressMonitor());
        IFileStore child2 = store.getChild("openFile.txt");
        this.fOS = child2.openOutputStream(0, this.getDefaultProgressMonitor());
        this.fOS.write("foobar\nbaz\n".getBytes());
        this.fOS.flush();
        exceptionThrown = false;
        try {
            treeStore.delete(0, this.getDefaultProgressMonitor());
            this.fOS.close();
            this.fOS = null;
        }
        catch (CoreException ce) {
            System.out.println("Good! Exception while deleting tree with open File: " + ce.getLocalizedMessage());
            int code3 = ce.getStatus().getCode();
            RSEFileStoreTest.assertTrue((code3 == 273 ? 1 : 0) != 0);
            exceptionThrown = true;
            this.fOS.close();
            this.fOS = null;
            treeStore.delete(0, this.getDefaultProgressMonitor());
        }
        IFileInfo treeInfo = treeStore.fetchInfo();
        RSEFileStoreTest.assertFalse((String)"5.1", (boolean)treeInfo.exists());
        RSEFileStoreTest.assertFalse((String)"5.2", (boolean)child1.fetchInfo().exists());
        RSEFileStoreTest.assertFalse((String)"5.3", (boolean)child2.fetchInfo().exists());
    }

    public void test255files() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        IFileStore f = this.fTestStore.getChild("f");
        f.mkdir(4, this.getDefaultProgressMonitor());
        int i = 0;
        while (i < 255) {
            IFileStore store = f.getChild("f" + i);
            this.fOS = store.openOutputStream(0, this.getDefaultProgressMonitor());
            this.fOS.write(String.valueOf(i).getBytes());
            this.fOS.flush();
            this.fOS.close();
            this.fOS = null;
            ++i;
        }
        IFileInfo[] infos = f.childInfos(0, this.getDefaultProgressMonitor());
        RSEFileStoreTest.assertTrue((String)"1", (infos.length == 255 ? 1 : 0) != 0);
        int i2 = 0;
        while (i2 < 255) {
            RSEFileStoreTest.assertTrue((String)"1.1", (boolean)infos[i2].exists());
            RSEFileStoreTest.assertFalse((String)"1.2", (boolean)infos[i2].isDirectory());
            ++i2;
        }
        f.delete(0, this.getDefaultProgressMonitor());
    }
}

