/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui;

import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.files.ui.resources.SystemUniversalTempFileListener;
import org.eclipse.rse.internal.files.ui.propertypages.SystemCachePreferencePage;
import org.eclipse.rse.internal.files.ui.propertypages.UniversalPreferencePage;
import org.eclipse.rse.internal.files.ui.resources.SystemRemoteEditManager;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static Activator plugin;
    private static SystemUniversalTempFileListener _tempFileListener;
    public static final String PLUGIN_ID = "org.eclipse.rse.files.ui";
    public static final String HELPPREFIX = "org.eclipse.rse.files.ui.";

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initializeDefaultRSEPreferences();
        InitRemoteEditJob job = new InitRemoteEditJob();
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
    }

    public void initializeDefaultRSEPreferences() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        SystemCachePreferencePage.initDefaults(store);
        UniversalPreferencePage.initDefaults(store);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (_tempFileListener != null) {
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            ws.removeResourceChangeListener((IResourceChangeListener)_tempFileListener);
            _tempFileListener = null;
        }
        plugin = null;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    private class InitRemoteEditJob
    extends Job {
        public InitRemoteEditJob() {
            super("InitRemoteEditJob");
        }

        protected IStatus run(IProgressMonitor monitor) {
            SystemRemoteEditManager.getInstance().getRemoteEditProject();
            SystemRemoteEditManager.getInstance().refreshRemoteEditProject();
            _tempFileListener = SystemUniversalTempFileListener.getListener();
            int eventMask = 1;
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            ws.addResourceChangeListener((IResourceChangeListener)_tempFileListener, eventMask);
            return Status.OK_STATUS;
        }
    }
}

