/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.importexport.files;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.internal.importexport.RemoteImportExportPlugin;
import org.eclipse.rse.internal.importexport.RemoteImportExportProblemDialog;
import org.eclipse.rse.internal.importexport.RemoteImportExportResources;
import org.eclipse.rse.internal.importexport.files.FileSystemStructureProvider;
import org.eclipse.rse.internal.importexport.files.IRemoteFileImportDescriptionReader;
import org.eclipse.rse.internal.importexport.files.RemoteFileImportData;
import org.eclipse.rse.internal.importexport.files.RemoteFileImportExportActionDelegate;
import org.eclipse.rse.internal.importexport.files.RemoteFileImportOperation;
import org.eclipse.rse.internal.importexport.files.RemoteFileOverwriteQuery;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.ui.PlatformUI;

public class RemoteFileImportActionDelegate
extends RemoteFileImportExportActionDelegate {
    public void run(IAction action) {
        MultiStatus mergedStatus;
        IFile[] descriptions = this.getDescriptionFiles(this.getSelection());
        int length = descriptions.length;
        if (length < 1) {
            return;
        }
        String message = length > 1 ? RemoteImportExportResources.IMPORT_EXPORT_ERROR_CREATE_FILES_FAILED : RemoteImportExportResources.IMPORT_EXPORT_ERROR_CREATE_FILE_FAILED;
        MultiStatus readStatus = new MultiStatus(RemoteImportExportPlugin.getDefault().getSymbolicName(), 0, message, null);
        RemoteFileImportData[] importDatas = this.readImportDatas(descriptions, readStatus);
        if (importDatas.length > 0) {
            IStatus status = this.importFiles(importDatas);
            if (status == null) {
                return;
            }
            message = readStatus.getSeverity() == 4 ? readStatus.getMessage() : status.getMessage();
            mergedStatus = new MultiStatus(RemoteImportExportPlugin.getDefault().getSymbolicName(), status.getCode(), readStatus.getChildren(), message, null);
            mergedStatus.merge(status);
        } else {
            mergedStatus = readStatus;
        }
        if (!mergedStatus.isOK()) {
            RemoteImportExportProblemDialog.open(this.getShell(), RemoteImportExportResources.IMPORT_EXPORT_IMPORT_ACTION_DELEGATE_TITLE, null, (IStatus)mergedStatus);
        }
    }

    private RemoteFileImportData[] readImportDatas(IFile[] descriptions, MultiStatus readStatus) {
        ArrayList<RemoteFileImportData> importDataList = new ArrayList<RemoteFileImportData>(descriptions.length);
        int i = 0;
        while (i < descriptions.length) {
            RemoteFileImportData importData = this.readImportData(descriptions[i], readStatus);
            if (importData != null) {
                importDataList.add(importData);
            }
            ++i;
        }
        return importDataList.toArray(new RemoteFileImportData[importDataList.size()]);
    }

    protected RemoteFileImportData readImportData(IFile description, MultiStatus readStatus) {
        Assert.isLegal((boolean)description.isAccessible());
        Assert.isNotNull((Object)description.getFileExtension());
        Assert.isLegal((boolean)description.getFileExtension().equals("rimpfd"));
        RemoteFileImportData importData = new RemoteFileImportData();
        IRemoteFileImportDescriptionReader reader = null;
        try {
            try {
                reader = importData.createImportDescriptionReader(description.getContents());
                reader.read(importData);
                importData.setSaveSettings(false);
            }
            catch (CoreException ex) {
                String message = NLS.bind((String)RemoteImportExportResources.IMPORT_EXPORT_ERROR_DESCRIPTION_READ, (Object)description.getFullPath(), (Object)ex.getStatus().getMessage());
                this.addToStatus(readStatus, message, ex);
                if (reader != null) {
                    readStatus.addAll(reader.getStatus());
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (CoreException ex2) {
                    String message2 = NLS.bind((String)RemoteImportExportResources.IMPORT_EXPORT_ERROR_DESCRIPTION_CLOSE, (Object)description.getFullPath());
                    this.addToStatus(readStatus, message2, ex2);
                }
                return null;
            }
        }
        finally {
            if (reader != null) {
                readStatus.addAll(reader.getStatus());
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (CoreException ex) {
                String message = NLS.bind((String)RemoteImportExportResources.IMPORT_EXPORT_ERROR_DESCRIPTION_CLOSE, (Object)description.getFullPath());
                this.addToStatus(readStatus, message, ex);
            }
        }
        return importData;
    }

    private IStatus importFiles(RemoteFileImportData[] importDatas) {
        IStatus status = null;
        int i = 0;
        while (i < importDatas.length) {
            RemoteFileImportOperation op = new RemoteFileImportOperation(importDatas[i], FileSystemStructureProvider.INSTANCE, new RemoteFileOverwriteQuery());
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)op);
                status = op.getStatus();
            }
            catch (InvocationTargetException e) {
                SystemBasePlugin.logError((String)"Error occured trying to import", (Throwable)e);
                status = new Status(4, RemoteImportExportPlugin.getDefault().getBundle().getSymbolicName(), 0, "", (Throwable)e);
            }
            catch (InterruptedException e) {
                SystemBasePlugin.logError((String)"Error occured trying to import", (Throwable)e);
                status = new Status(0, RemoteImportExportPlugin.getDefault().getBundle().getSymbolicName(), 0, "", (Throwable)e);
            }
            if (!status.isOK()) {
                String msgTxt = NLS.bind((String)RemoteImportExportResources.FILEMSG_IMPORT_FAILED, (Object)status);
                Throwable e = status.getException();
                SimpleSystemMessage msg = null;
                msg = e != null ? new SimpleSystemMessage("org.eclipse.rse.importexport", "RSEF8070", 4, msgTxt, e) : new SimpleSystemMessage("org.eclipse.rse.importexport", "RSEF8070", 4, msgTxt);
                SystemMessageDialog dlg = new SystemMessageDialog(this.getShell(), (SystemMessage)msg);
                dlg.openWithDetails();
                return null;
            }
            ++i;
        }
        return null;
    }

    protected void addToStatus(MultiStatus multiStatus, String defaultMessage, CoreException ex) {
        IStatus status = ex.getStatus();
        String message = ex.getLocalizedMessage();
        if (message == null || message.length() < 1) {
            status = new Status(status.getSeverity(), status.getPlugin(), status.getCode(), defaultMessage, (Throwable)ex);
        }
        multiStatus.add(status);
    }
}

