/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.internal.extra;

import java.util.ArrayList;
import org.eclipse.dstore.extra.DomainEvent;
import org.eclipse.dstore.extra.IDomainListener;
import org.eclipse.dstore.extra.IDomainNotifier;

public class DomainNotifier
implements IDomainNotifier {
    private ArrayList _listeners = new ArrayList();
    private boolean _enabled = false;

    public void enable(boolean on) {
        this._enabled = on;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void addDomainListener(IDomainListener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    public void fireDomainChanged(DomainEvent event) {
        if (this._enabled) {
            int i = 0;
            while (i < this._listeners.size()) {
                IDomainListener listener = (IDomainListener)this._listeners.get(i);
                if (listener != null && listener.listeningTo(event)) {
                    listener.domainChanged(event);
                }
                ++i;
            }
        }
    }

    public boolean hasDomainListener(IDomainListener listener) {
        return this._listeners.contains(listener);
    }

    public void removeDomainListener(IDomainListener listener) {
        this._listeners.remove(listener);
    }
}

