/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.parsers.asn1parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.Pair;
import org.eclipse.core.resources.IFile;
import org.eclipse.titan.designer.AST.ASN1.Block;
import org.eclipse.titan.designer.parsers.asn1parser.ASN1Listener;
import org.eclipse.titan.designer.parsers.asn1parser.Asn1Parser;
import org.eclipse.titan.designer.parsers.asn1parser.TokenWithIndexAndSubTokens;

public class SyntaxLevelTokenStreamTracker
extends CommonTokenStream {
    private HashSet<Integer> discardMask = new HashSet();
    private IFile sourceFile;
    private int index;
    private List<Token> oldList;

    protected SyntaxLevelTokenStreamTracker(Block aBlock, int startIndex) {
        super((TokenSource)aBlock);
        this.index = startIndex;
        this.oldList = aBlock.getTokenList();
    }

    public void setActualFile(IFile sourceFile) {
        this.sourceFile = sourceFile;
    }

    public void discard(int ttype) {
        this.discardMask.add(ttype);
    }

    public int getActualIndex() {
        return this.index;
    }

    public int fetch(int n) {
        if (this.fetchedEOF) {
            return 0;
        }
        int i = 0;
        if (this.oldList == null || this.index >= this.oldList.size()) {
            this.tokens.add(new TokenWithIndexAndSubTokens(-1));
            return ++i;
        }
        do {
            Token t;
            Token first = t = this.oldList.get(this.index++);
            if (t == null) {
                return 0;
            }
            if (this.discardMask.contains(t.getType())) continue;
            if (t.getType() == 114) {
                boolean exit = this.getBlock(first);
                if (exit) {
                    return ++i;
                }
                ++i;
                --n;
                continue;
            }
            this.tokens.add(t);
            ++i;
            --n;
        } while (0 < n);
        return i;
    }

    public static Asn1Parser getASN1ParserForBlock(Block aBlock) {
        return SyntaxLevelTokenStreamTracker.getASN1ParserForBlock(aBlock, 0);
    }

    public static Asn1Parser getASN1ParserForBlock(Block aBlock, int startIndex) {
        if (aBlock == null || aBlock.getLocation() == null) {
            return null;
        }
        SyntaxLevelTokenStreamTracker tracker = new SyntaxLevelTokenStreamTracker(aBlock, startIndex);
        tracker.discard(2);
        tracker.discard(100);
        tracker.discard(99);
        Asn1Parser parser = new Asn1Parser((TokenStream)tracker);
        tracker.setActualFile((IFile)aBlock.getLocation().getFile());
        parser.setActualFile((IFile)aBlock.getLocation().getFile());
        parser.setBuildParseTree(false);
        ASN1Listener parserListener = new ASN1Listener(parser);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)parserListener);
        return parser;
    }

    private boolean getBlock(Token first) {
        if (this.index >= this.oldList.size()) {
            this.tokens.add(first);
            return true;
        }
        Token t = this.oldList.get(this.index++);
        ArrayList<Token> tokenList = new ArrayList<Token>();
        int nofUnclosedParanthesis = 1;
        while (t != null && t.getType() != -1 && this.index < this.oldList.size()) {
            if (t.getType() == 114) {
                ++nofUnclosedParanthesis;
            } else if (t.getType() == 115 && --nofUnclosedParanthesis == 0) {
                TokenWithIndexAndSubTokens result = new TokenWithIndexAndSubTokens((Pair<TokenSource, CharStream>)new Pair((Object)this.getTokenSource(), (Object)this.getTokenSource().getInputStream()), 1, 0, ((TokenWithIndexAndSubTokens)first).getStopIndex(), ((TokenWithIndexAndSubTokens)t).getStopIndex(), tokenList, this.sourceFile);
                result.setCharPositionInLine(first.getCharPositionInLine());
                result.setLine(first.getLine());
                result.setText(this.makeString(tokenList));
                this.tokens.add(result);
                return false;
            }
            if (!this.discardMask.contains(t.getType())) {
                tokenList.add(t);
            }
            t = this.oldList.get(this.index++);
        }
        TokenWithIndexAndSubTokens result = new TokenWithIndexAndSubTokens((Pair<TokenSource, CharStream>)new Pair((Object)this.getTokenSource(), (Object)this.getTokenSource().getInputStream()), 1, 0, ((TokenWithIndexAndSubTokens)first).getStopIndex(), t == null ? 0 : ((TokenWithIndexAndSubTokens)t).getStopIndex(), tokenList, this.sourceFile);
        result.setCharPositionInLine(first.getCharPositionInLine());
        result.setLine(first.getLine());
        this.tokens.add(result);
        return true;
    }

    private String makeString(List<Token> list) {
        StringBuilder text = new StringBuilder();
        for (Token t : list) {
            text.append(t.getText());
        }
        return text.toString();
    }
}

