/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.titan.log.viewer.utils.ActionUtils;
import org.eclipse.titan.log.viewer.utils.SelectionUtils;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CloseAllConnectedViewMenuAction
extends AbstractHandler
implements IActionDelegate {
    private IStructuredSelection selection;
    private IFile logFile;

    public void run(IAction action) {
        this.run(this.selection);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection tempSelection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (!(tempSelection instanceof IStructuredSelection)) {
            return null;
        }
        this.selection = (IStructuredSelection)tempSelection;
        this.run(this.selection);
        return null;
    }

    public void run(IStructuredSelection selection) {
        if (this.selection == null) {
            return;
        }
        if (!SelectionUtils.isSelectionALogFile((ISelection)this.selection)) {
            return;
        }
        this.logFile = SelectionUtils.selectionToIFile((ISelection)this.selection);
        if (this.logFile == null) {
            return;
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewReference[] viewReferences = activePage.getViewReferences();
        ActionUtils.closeAssociatedViews(activePage, viewReferences, (IResource)this.logFile);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        this.selection = (IStructuredSelection)selection;
        this.setEnabled(SelectionUtils.isSelectionALogFile(selection));
    }
}

