/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titan.designer.editors.ttcnppeditor.TTCNPPEditor;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.error.GUIErrorHandler;
import org.eclipse.titanium.graph.components.NodeDescriptor;
import org.eclipse.titanium.graph.gui.windows.ModuleGraphEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public final class ModuleGraphFromEditor
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor == null || !(editor instanceof TTCN3Editor) && !(editor instanceof TTCNPPEditor)) {
            ErrorReporter.logError((String)"The editor is not found or not a Titan TTCN-3 editor");
            return null;
        }
        IFile file = (IFile)editor.getEditorInput().getAdapter(IFile.class);
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser((IProject)file.getProject());
        Module actualModule = projectSourceParser.containedModule(file);
        IProject project = file.getProject();
        Generator generator = new Generator(project, actualModule);
        generator.schedule();
        return null;
    }

    public static class Generator
    extends Job {
        private final IProject project;
        private final Module actualModule;

        Generator(IProject project, Module actualModule) {
            super("Generator");
            this.project = project;
            this.actualModule = actualModule;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Parsing project", 30);
            IFile input = null;
            try {
                IResource[] members;
                for (IResource res : members = this.project.members()) {
                    if (res.getType() == 1) {
                        input = (IFile)res;
                        break;
                    }
                    if (res.getType() != 2) continue;
                    members = ((IFolder)res).members();
                }
            }
            catch (CoreException ce) {
                GUIErrorHandler errorHandler = new GUIErrorHandler();
                errorHandler.reportException("Error while parsing the project", (Exception)((Object)ce));
            }
            final IFile finalInput = input;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        FileEditorInput editorInput = new FileEditorInput(finalInput);
                        IEditorPart editor = page.findEditor((IEditorInput)editorInput);
                        if (editor == null) {
                            editor = page.openEditor((IEditorInput)editorInput, "org.eclipse.titanium.graph.editors.ModuleGraphEditor", true, 3);
                        }
                        if (editor == null) {
                            return;
                        }
                        final ModuleGraphEditor actualEditor = (ModuleGraphEditor)editor;
                        NodeDescriptor foundNode = null;
                        for (NodeDescriptor node : actualEditor.getGraph().getVertices()) {
                            if (!node.getName().equals(actualModule.getName().toString())) continue;
                            foundNode = node;
                        }
                        if (foundNode != null) {
                            final NodeDescriptor tempNode = foundNode;
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        actualEditor.elemChosen(tempNode);
                                    }
                                    catch (Exception exc) {
                                        GUIErrorHandler errorHandler = new GUIErrorHandler();
                                        errorHandler.reportException("Error while setting color node", exc);
                                    }
                                }
                            });
                        }
                    }
                    catch (Exception exc) {
                        GUIErrorHandler errorHandler = new GUIErrorHandler();
                        errorHandler.reportException("Error while selecting the node", exc);
                    }
                }
            });
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

