/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.actions;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titanium.markers.export.BaseProblemExporter;
import org.eclipse.titanium.markers.export.XlsProblemExporter;
import org.eclipse.titanium.utils.ProjectAnalyzerJob;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public final class ExportProblems
extends AbstractHandler
implements IObjectActionDelegate {
    private ISelection selection;

    public void run(IAction action) {
        this.doExportProblems();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        this.doExportProblems();
        return null;
    }

    private void doExportProblems() {
        String fileName;
        if (!(this.selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structSelection = (IStructuredSelection)this.selection;
        if (structSelection.isEmpty()) {
            return;
        }
        Object firstElement = structSelection.getFirstElement();
        if (!(firstElement instanceof IProject)) {
            ErrorReporter.logError((String)"The export problems command needs to be called on a project ");
            return;
        }
        IProject project = (IProject)firstElement;
        IPreferencesService preferencesService = Platform.getPreferencesService();
        final boolean reportDebugInformation = preferencesService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null);
        if (reportDebugInformation) {
            TITANDebugConsole.println((String[])new String[]{"Problem markers are to export from " + project.getName()});
        }
        boolean write = false;
        Shell shell = Display.getCurrent().getActiveShell();
        do {
            FileDialog dialog = new FileDialog(shell, 8192);
            dialog.setText("Export problem markers to xls");
            dialog.setFilterExtensions(new String[]{"*.xls"});
            IPath path = project.getLocation();
            if (path != null) {
                dialog.setFilterPath(path.toPortableString());
            }
            Calendar now = Calendar.getInstance();
            dialog.setFileName("Problems--" + project.getName() + "--" + now.get(1) + "-" + (1 + now.get(2)) + "-" + now.get(5));
            fileName = dialog.open();
            if (fileName != null) {
                if (new File(fileName).exists()) {
                    write = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"File exist", (String)"This file already exists. Please confirm overwrite.");
                    continue;
                }
                write = true;
                continue;
            }
            return;
        } while (!write);
        final String fileName2 = fileName;
        new ProjectAnalyzerJob("Exporting reported code smells"){

            @Override
            public IStatus doPostWork(IProgressMonitor monitor) {
                block3: {
                    XlsProblemExporter exporter = new XlsProblemExporter(this.getProject());
                    try {
                        ((BaseProblemExporter)exporter).exportMarkers(monitor, fileName2, Calendar.getInstance().getTime());
                        if (reportDebugInformation) {
                            TITANDebugConsole.println((String[])new String[]{"Successfully exported markers to xls"});
                        }
                    }
                    catch (IOException e) {
                        ErrorReporter.logExceptionStackTrace((String)"Error while exporting", (Throwable)e);
                        if (!reportDebugInformation) break block3;
                        TITANDebugConsole.println((String[])new String[]{"Failed to write xls"});
                    }
                }
                return Status.OK_STATUS;
            }
        }.quickSchedule(project);
    }
}

