/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.jar;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.tea.library.build.jar.ZipExecPart;

public interface ZipExecInterceptor {
    public List<ZipExecPart> convert(ZipExecPart var1);

    public static ZipExecInterceptor neutralInterceptor() {
        return new ZipExecInterceptor(){

            @Override
            public List<ZipExecPart> convert(ZipExecPart part) {
                return Collections.singletonList(part);
            }
        };
    }

    public static ZipExecInterceptor replaceFileInterceptor(final String relativePathToReplace, final File replacementSourceDirectory, final String replacementRelativePath) {
        return new ZipExecInterceptor(){

            @Override
            public List<ZipExecPart> convert(ZipExecPart part) {
                ArrayList<ZipExecPart> parts = new ArrayList<ZipExecPart>();
                ZipExecPart converted = new ZipExecPart(part);
                converted.relativePaths.remove(relativePathToReplace);
                parts.add(converted);
                ZipExecPart additionalPart = new ZipExecPart(part);
                additionalPart.relativePaths.clear();
                additionalPart.sourceDirectory = replacementSourceDirectory;
                additionalPart.relativePaths.add(replacementRelativePath);
                parts.add(additionalPart);
                return parts;
            }
        };
    }
}

