/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.core.treepartitioner;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.statet.ecommons.text.core.PartitionConstraint;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartition;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNode;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeType;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;

@NonNullByDefault
public class TreePartitionUtils {
    public static final TreePartitionNode getRootNode(IDocument document, String partitioning) {
        try {
            TreePartitionNode parent;
            TreePartition partition = (TreePartition)TextUtilities.getPartition((IDocument)document, (String)partitioning, (int)0, (boolean)false);
            TreePartitionNode node = partition.getTreeNode();
            while ((parent = node.getParent()) != null) {
                node = parent;
            }
            return node;
        }
        catch (BadLocationException e) {
            throw new IllegalStateException(e);
        }
    }

    public static final @Nullable TreePartitionNode getNode(IDocument document, String partitioning, int offset, boolean prefereOpen) throws BadLocationException {
        TreePartition partition = (TreePartition)TextUtilities.getPartition((IDocument)document, (String)partitioning, (int)offset, (boolean)prefereOpen);
        if (partition instanceof TreePartition) {
            return partition.getTreeNode();
        }
        return null;
    }

    public static final @Nullable TreePartitionNode searchNodeUp(@Nullable TreePartitionNode node, TreePartitionNodeType type) {
        while (node != null && type != node.getType()) {
            node = node.getParent();
        }
        return node;
    }

    public static final @Nullable TreePartitionNode searchNodeUp(@Nullable TreePartitionNode node, String partitionType) {
        while (node != null && partitionType != node.getType().getPartitionType()) {
            node = node.getParent();
        }
        return node;
    }

    public static final @Nullable TreePartitionNode searchNodeUp(@Nullable TreePartitionNode node, PartitionConstraint partitionConstraint) {
        while (node != null && !partitionConstraint.matches(node.getType().getPartitionType())) {
            node = node.getParent();
        }
        return node;
    }

    public static final @Nullable TreePartitionNode searchNode(IDocument document, String partitioning, int offset, boolean prefereOpen, TreePartitionNodeType type) throws BadLocationException {
        TreePartition partition = (TreePartition)TextUtilities.getPartition((IDocument)document, (String)partitioning, (int)offset, (boolean)prefereOpen);
        return TreePartitionUtils.searchNodeUp(partition.getTreeNode(), type);
    }

    public static final @Nullable TreePartitionNode searchNode(IDocument document, String partitioning, int offset, boolean prefereOpen, String partitionType) throws BadLocationException {
        TreePartition partition = (TreePartition)TextUtilities.getPartition((IDocument)document, (String)partitioning, (int)offset, (boolean)prefereOpen);
        return TreePartitionUtils.searchNodeUp(partition.getTreeNode(), partitionType);
    }

    public static final @Nullable TreePartitionNode searchNode(IDocument document, String partitioning, int offset, boolean prefereOpen, PartitionConstraint partitionConstraint) throws BadLocationException {
        TreePartition partition = (TreePartition)TextUtilities.getPartition((IDocument)document, (String)partitioning, (int)offset, (boolean)prefereOpen);
        return TreePartitionUtils.searchNodeUp(partition.getTreeNode(), partitionConstraint);
    }

    public static final @Nullable TextRegion searchPartitionRegion(IDocument document, String partitioning, int offset, boolean prefereOpen, PartitionConstraint partitionConstraint) throws BadLocationException {
        return TreePartitionUtils.searchPartitionRegion((TreePartition)TextUtilities.getPartition((IDocument)document, (String)partitioning, (int)offset, (boolean)prefereOpen), partitionConstraint);
    }

    public static final @Nullable TextRegion searchPartitionRegion(TreePartition partition, PartitionConstraint partitionConstraint) {
        if (partition == null) {
            throw new NullPointerException("partition");
        }
        if (!partitionConstraint.matches(partition.getType())) {
            return null;
        }
        int begin = TreePartitionUtils.searchBegin(partition.getTreeNode(), partition.getOffset(), partitionConstraint);
        int end = TreePartitionUtils.searchEnd(partition.getTreeNode(), partition.getEndOffset(), partitionConstraint);
        return new BasicTextRegion(begin, end);
    }

    private static int searchBegin(TreePartitionNode node, int offset, PartitionConstraint partitionConstraint) {
        int childCount = node.getChildCount();
        int childIdx = node.indexOfChild(offset);
        if (childIdx < 0) {
            childIdx ^= 0xFFFFFFFF;
        }
        if (childIdx == childCount) {
            --childIdx;
        }
        while (childIdx >= 0) {
            TreePartitionNode child = node.getChild(childIdx);
            if (!partitionConstraint.matches(child.getType().getPartitionType())) {
                return child.getEndOffset();
            }
            int stop = TreePartitionUtils.searchBeginChild(node, partitionConstraint);
            if (stop >= 0) {
                return stop;
            }
            --childIdx;
        }
        TreePartitionNode parent = node.getParent();
        if (parent == null || !partitionConstraint.matches(parent.getType().getPartitionType())) {
            return node.getStartOffset();
        }
        return TreePartitionUtils.searchBegin(parent, offset, partitionConstraint);
    }

    private static int searchBeginChild(TreePartitionNode node, PartitionConstraint partitionConstraint) {
        int childCount = node.getChildCount();
        int childIdx = childCount - 1;
        while (childIdx >= 0) {
            TreePartitionNode child = node.getChild(childIdx);
            if (!partitionConstraint.matches(child.getType().getPartitionType())) {
                return child.getEndOffset();
            }
            int stop = TreePartitionUtils.searchBeginChild(child, partitionConstraint);
            if (stop >= 0) {
                return stop;
            }
            --childIdx;
        }
        return -1;
    }

    private static int searchEnd(TreePartitionNode node, int offset, PartitionConstraint partitionConstraint) {
        int childIdx;
        int childCount = node.getChildCount();
        int n = childIdx = offset == node.getStartOffset() ? 0 : node.indexOfChild(offset);
        if (childIdx < 0) {
            childIdx ^= 0xFFFFFFFF;
        }
        while (childIdx < childCount) {
            TreePartitionNode child = node.getChild(childIdx);
            if (!partitionConstraint.matches(child.getType().getPartitionType())) {
                return child.getStartOffset();
            }
            int stop = TreePartitionUtils.searchEndChild(node, partitionConstraint);
            if (stop >= 0) {
                return stop;
            }
            ++childIdx;
        }
        TreePartitionNode parent = node.getParent();
        if (parent == null || !partitionConstraint.matches(parent.getType().getPartitionType())) {
            return node.getEndOffset();
        }
        return TreePartitionUtils.searchEnd(parent, offset, partitionConstraint);
    }

    private static int searchEndChild(TreePartitionNode node, PartitionConstraint partitionConstraint) {
        int childCount = node.getChildCount();
        int childIdx = 0;
        while (childIdx < childCount) {
            TreePartitionNode child = node.getChild(childIdx);
            if (!partitionConstraint.matches(child.getType().getPartitionType())) {
                return child.getStartOffset();
            }
            int stop = TreePartitionUtils.searchEndChild(child, partitionConstraint);
            if (stop >= 0) {
                return stop;
            }
            ++childIdx;
        }
        return -1;
    }

    private TreePartitionUtils() {
    }

    public static class PartitionPrinter {
        private final Writer writer;
        private @Nullable IDocument document;
        private int maxFragmentSize = 25;

        public PartitionPrinter(Writer writer) {
            if (writer == null) {
                throw new NullPointerException("writer");
            }
            this.writer = writer;
        }

        public void setMaxFragmentSize(int size) {
            this.maxFragmentSize = size;
        }

        public void print(TreePartitionNode node, IDocument document) throws IOException {
            this.document = document;
            try {
                this.print(node, 0);
            }
            finally {
                this.document = null;
            }
        }

        public void print(List<TreePartition> partitions, IDocument document) throws IOException {
            this.document = document;
            try {
                this.print(partitions);
            }
            finally {
                this.document = null;
            }
        }

        protected void print(TreePartitionNode node, int nodeDepth) throws IOException {
            this.printIdent(nodeDepth);
            int startOffset = node.getStartOffset();
            int endOffset = node.getEndOffset();
            this.writer.write(91);
            this.writer.write(Integer.toString(startOffset));
            this.writer.write(", ");
            this.writer.write(Integer.toString(endOffset));
            this.writer.write(") ");
            this.writer.write(node.getType().toString());
            this.printFragment(startOffset, endOffset);
            this.writer.write(10);
            int childCount = node.getChildCount();
            int childIdx = 0;
            while (childIdx < childCount) {
                this.print(node.getChild(childIdx), nodeDepth + 1);
                ++childIdx;
            }
        }

        protected void print(List<TreePartition> partitions) throws IOException {
            int i = 0;
            while (i < partitions.size()) {
                TreePartition partition = partitions.get(i);
                int startOffset = partition.getOffset();
                int endOffset = partition.getEndOffset();
                this.writer.write(91);
                this.writer.write(Integer.toString(startOffset));
                this.writer.write(", ");
                this.writer.write(Integer.toString(endOffset));
                this.writer.write(") ");
                this.writer.write(partition.getType());
                this.printFragment(startOffset, endOffset);
                this.writer.append('\n');
                ++i;
            }
        }

        protected void printIdent(int depth) throws IOException {
            int i = 0;
            while (i < depth) {
                this.writer.write("    ");
                ++i;
            }
        }

        protected void printFragment(int startOffset, int endOffset) throws IOException {
            IDocument document = this.document;
            if (document != null && this.maxFragmentSize > 0) {
                try {
                    this.writer.write(": ");
                    int l = endOffset - startOffset;
                    if (l <= this.maxFragmentSize) {
                        this.writeEncoded(document.get(startOffset, l));
                    } else if (this.maxFragmentSize < 13) {
                        this.writeEncoded(document.get(startOffset, this.maxFragmentSize - 3));
                        this.writer.write(" ... ");
                    } else {
                        l = (this.maxFragmentSize - 3) / 2;
                        this.writeEncoded(document.get(startOffset, l));
                        this.writer.write(" ... ");
                        this.writeEncoded(document.get(endOffset - l, l));
                    }
                }
                catch (BadLocationException e) {
                    this.writer.write("!!!ERROR!!!");
                }
            }
        }

        private void writeEncoded(String s) throws IOException {
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                if (c < '\u0010') {
                    this.writer.write("<0x0");
                    this.writer.write(Integer.toHexString(c));
                    this.writer.write(62);
                } else if (c < ' ') {
                    this.writer.write("<0x");
                    this.writer.write(Integer.toHexString(c));
                    this.writer.write(62);
                } else {
                    this.writer.write(c);
                }
                ++i;
            }
        }
    }
}

