/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.content;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.collections.FastList;
import org.eclipse.statet.ecommons.ui.content.IElementFilter;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.collections.IntArrayMap;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Event;

public class TableFilterController {
    private final TableViewer fViewer;
    private int fUpdate;
    private final RefreshJob fRefreshJob;
    private List<?> fInput = Collections.emptyList();
    private int fInputId;
    private final IntArrayMap<IElementFilter> fFilter = new IntArrayMap(8);
    private int fMaxFilter = -1;
    private final FastList<Listener> fListener = new FastList(Listener.class);

    public TableFilterController(TableViewer viewer) {
        this.fViewer = viewer;
        this.fRefreshJob = new RefreshJob();
        this.fViewer.getTable().getVerticalBar().setVisible(true);
        this.fViewer.setContentProvider((IContentProvider)this.fRefreshJob);
        this.fViewer.setInput((Object)this);
        viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TableFilterController.this.fRefreshJob.cancel();
            }
        });
    }

    protected long getRefreshJobDelay() {
        return 10L;
    }

    public void addListener(Listener listener) {
        this.fListener.add((Object)listener);
    }

    public void removeListener(Listener listener) {
        this.fListener.remove((Object)listener);
    }

    protected void notifyListeners(boolean newInput) {
        Listener[] array;
        Listener[] listenerArray = array = (Listener[])this.fListener.toArray();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Listener listener = listenerArray[n2];
            listener.inputUpdated(newInput);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isUpToDate() {
        if (this.fUpdate == 0 && this.fRefreshJob.getState() == 0) {
            TableFilterController tableFilterController = this;
            synchronized (tableFilterController) {
                return !this.fRefreshJob.fDisplayScheduled;
            }
        }
        return false;
    }

    public TableViewer getViewer() {
        return this.fViewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(int id, IElementFilter provider) {
        TableFilterController tableFilterController = this;
        synchronized (tableFilterController) {
            if (id > this.fMaxFilter) {
                this.fMaxFilter = id;
            }
            this.fFilter.put(id, (Object)provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addFilter(IElementFilter provider) {
        TableFilterController tableFilterController = this;
        synchronized (tableFilterController) {
            ++this.fMaxFilter;
            this.fFilter.put(this.fMaxFilter, (Object)provider);
            return this.fMaxFilter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInput(List<?> input) {
        if (input == null) {
            throw new NullPointerException("input");
        }
        TableFilterController tableFilterController = this;
        synchronized (tableFilterController) {
            this.fInput = input;
            ++this.fInputId;
        }
        if (this.fUpdate == 0) {
            this.fRefreshJob.schedule();
        }
    }

    public void refresh(boolean direct) {
        this.fRefreshJob.cancel();
        this.fRefreshJob.schedule(direct ? 0L : this.getRefreshJobDelay());
    }

    public void startUpdate() {
        if (this.fUpdate == 0) {
            this.fRefreshJob.cancel();
        }
        ++this.fUpdate;
    }

    public void endUpdate() {
        --this.fUpdate;
        if (this.fUpdate == 0) {
            this.fRefreshJob.schedule();
        }
    }

    public void setSelection(Object element) {
        if (this.fUpdate == 0 && this.fRefreshJob.fActiveInput != null) {
            int idx = this.fRefreshJob.fActiveInput.indexOf(element);
            if (idx < 0) {
                return;
            }
            if ((idx = this.fRefreshJob.model2active(idx)) < 0) {
                return;
            }
            this.fViewer.getTable().setSelection(idx);
            this.fViewer.getTable().showSelection();
            this.fViewer.getTable().notifyListeners(13, new Event());
        }
    }

    public void setSelection(List<?> elements) {
        if (this.fUpdate == 0 && this.fRefreshJob.fActiveInput != null) {
            int[] idxs = new int[elements.size()];
            int i = 0;
            for (Object element : elements) {
                int idx = this.fRefreshJob.fActiveInput.indexOf(element);
                if (idx < 0 || (idx = this.fRefreshJob.model2active(idx)) < 0) continue;
                idxs[i++] = idx;
            }
            if (i != idxs.length) {
                idxs = Arrays.copyOf(idxs, i);
            }
            this.fViewer.getTable().setSelection(idxs);
            this.fViewer.getTable().showSelection();
            this.fViewer.getTable().notifyListeners(13, new Event());
        }
    }

    public void schedule(final Runnable runnable) {
        if (this.isUpToDate()) {
            runnable.run();
            return;
        }
        this.addListener(new Listener(){

            @Override
            public void inputUpdated(boolean newInput) {
                TableFilterController.this.removeListener(this);
                runnable.run();
            }
        });
    }

    public static interface Listener {
        public void inputUpdated(boolean var1);
    }

    private class RefreshJob
    extends Job
    implements ILazyContentProvider,
    Runnable {
        private int[] fTemp;
        private int fFilterInputId;
        private IElementFilter.IFinalFilter[] fCacheFilters;
        private int[][] fCacheData;
        private int fCompleteInputId;
        private int[] fCompleteData;
        private int fActiveInputId;
        private List<?> fActiveInput;
        private int[] fActiveData;
        private boolean fDisplayScheduled;

        public RefreshJob() {
            super("Refresh Filter");
            this.fFilterInputId = -1;
            this.fCacheFilters = new IElementFilter.IFinalFilter[4];
            this.fCacheData = new int[4][];
            this.fActiveInputId = -1;
            this.setPriority(10);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        protected IStatus run(IProgressMonitor monitor) {
            var5_2 = TableFilterController.this;
            synchronized (var5_2) {
                currentProvider = (IElementFilter[])TableFilterController.this.fFilter.toArray(IElementFilter.class);
                currentInput = TableFilterController.this.fInput;
                currentInputId = TableFilterController.this.fInputId;
            }
            currentFilters = new IElementFilter.IFinalFilter[currentProvider.length];
            newData = currentInputId != this.fFilterInputId;
            i = 0;
            while (i < currentFilters.length) {
                provider = currentProvider[i];
                currentFilters[i] = provider != null ? provider.getFinal(newData) : null;
                ++i;
            }
            if (newData) {
                this.fFilterInputId = currentInputId;
                i = 0;
                while (i < this.fCacheFilters.length) {
                    this.fCacheFilters[i] = null;
                    this.fCacheData[i] = null;
                    ++i;
                }
            }
            if (this.fCacheFilters.length < currentFilters.length) {
                this.fCacheFilters = Arrays.copyOf(this.fCacheFilters, currentFilters.length);
                this.fCacheData = (int[][])Arrays.copyOf(this.fCacheData, currentFilters.length);
            }
            if (this.fTemp == null || this.fTemp.length < currentInput.size()) {
                this.fTemp = new int[currentInput.size()];
            }
            data = new int[currentFilters.length][];
            filterIdx = 0;
            while (filterIdx < currentFilters.length) {
                block34: {
                    filter = currentFilters[filterIdx];
                    if (filter == null) break block34;
                    if (this.fCacheFilters[filterIdx] == null || !filter.isSubOf(this.fCacheFilters[filterIdx])) ** GOTO lbl-1000
                    prev = this.fCacheData[filterIdx];
                    if (filter.isEqualTo(this.fCacheFilters[filterIdx])) {
                        data[filterIdx] = prev;
                    } else if (prev != null) {
                        filtered = this.fTemp;
                        idx = 0;
                        num = prev.length;
                        prevIdx = 0;
                        while (prevIdx < num) {
                            if (prevIdx % 50 == 0 && monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            if (filter.select(currentInput.get(prev[prevIdx]))) {
                                filtered[idx++] = prev[prevIdx];
                            }
                            ++prevIdx;
                        }
                        data[filterIdx] = idx == num ? prev : Arrays.copyOf(filtered, idx);
                        this.fCacheFilters[filterIdx] = filter;
                        this.fCacheData[filterIdx] = data[filterIdx];
                    } else lbl-1000:
                    // 2 sources

                    {
                        filtered = this.fTemp;
                        idx = 0;
                        num = currentInput.size();
                        prevIdx = 0;
                        while (prevIdx < num) {
                            if (prevIdx % 50 == 0 && monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            if (filter.select(currentInput.get(prevIdx))) {
                                filtered[idx++] = prevIdx;
                            }
                            ++prevIdx;
                        }
                        data[filterIdx] = (int[])(idx == num ? null : Arrays.copyOf(filtered, idx));
                        this.fCacheFilters[filterIdx] = filter;
                        this.fCacheData[filterIdx] = data[filterIdx];
                    }
                }
                ++filterIdx;
            }
            merge = null;
            num = -1;
            filterIdx = 0;
            while (filterIdx < currentFilters.length) {
                filtered = data[filterIdx];
                if (filtered != null) {
                    if (merge == null) {
                        merge = filtered;
                    } else {
                        if (merge != this.fTemp) {
                            num = merge.length;
                            System.arraycopy(merge, 0, this.fTemp, 0, num);
                            merge = this.fTemp;
                        }
                        idx = 0;
                        i = 0;
                        j = 0;
                        block12: while (i < num) {
                            tmp = merge[i];
                            while (j < filtered.length) {
                                if (filtered[j] < tmp) {
                                    ++j;
                                    continue;
                                }
                                if (filtered[j] == tmp) {
                                    merge[idx++] = tmp;
                                    ++j;
                                }
                                ++i;
                                continue block12;
                            }
                            break block12;
                        }
                        num = idx;
                    }
                }
                ++filterIdx;
            }
            if (merge != null && num >= 0 && (merge.length != num || merge == this.fTemp)) {
                merge = Arrays.copyOf(merge, num);
            }
            var9_14 = TableFilterController.this;
            synchronized (var9_14) {
                this.fCompleteInputId = currentInputId;
                this.fCompleteData = merge;
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (this.fDisplayScheduled) {
                    return Status.OK_STATUS;
                }
                this.fDisplayScheduled = true;
            }
            TableFilterController.this.fViewer.getTable().getDisplay().asyncExec((Runnable)this);
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean newInput;
            int inputId;
            List<?> input;
            int completeInputId;
            int[] completeData;
            if (!UIAccess.isOkToUse((Viewer)TableFilterController.this.fViewer)) {
                return;
            }
            TableFilterController tableFilterController = TableFilterController.this;
            synchronized (tableFilterController) {
                completeData = this.fCompleteData;
                completeInputId = this.fCompleteInputId;
                input = TableFilterController.this.fInput;
                inputId = TableFilterController.this.fInputId;
                this.fDisplayScheduled = false;
            }
            boolean bl = newInput = this.fActiveInputId != completeInputId;
            if (completeInputId == inputId) {
                IStructuredSelection selection = (IStructuredSelection)TableFilterController.this.fViewer.getSelection();
                int idx = 0;
                int count = -1 + TableFilterController.this.fViewer.getTable().getClientArea().height / TableFilterController.this.fViewer.getTable().getItemHeight();
                if ((completeData == null || completeData.length >= count) && (idx = TableFilterController.this.fViewer.getTable().getTopIndex()) >= 0) {
                    int idx2 = -1;
                    if (count > 0) {
                        int[] idxs = TableFilterController.this.fViewer.getTable().getSelectionIndices();
                        int i = 0;
                        while (i < idxs.length) {
                            if (idxs[i] >= idx && idxs[i] < idx + count) {
                                idx2 = idxs[i];
                                break;
                            }
                            ++i;
                        }
                    }
                    idx = this.active2model(idx);
                    idx2 = this.active2model(idx2);
                    if (completeData != null) {
                        if (idx >= 0 && (idx = Arrays.binarySearch(completeData, idx)) < 0) {
                            idx = -idx - 1;
                        }
                        if (idx2 >= 0) {
                            idx2 = Arrays.binarySearch(completeData, idx2);
                        }
                    }
                    if (idx >= 0 && idx2 >= 0 && idx2 - idx > count) {
                        idx = idx2 - count + 1;
                    }
                }
                if (input != null && completeData != null && completeData.length == 1) {
                    selection = new StructuredSelection(input.get(completeData[0]));
                }
                this.fActiveInputId = completeInputId;
                this.fActiveInput = input;
                this.fActiveData = completeData;
                TableFilterController.this.fViewer.setItemCount(completeData != null ? completeData.length : input.size());
                if (idx >= 0) {
                    TableFilterController.this.fViewer.getTable().setTopIndex(idx);
                }
                TableFilterController.this.fViewer.refresh(newInput);
                TableFilterController.this.fViewer.setSelection((ISelection)selection);
                TableFilterController.this.fViewer.getTable().getParent().layout();
            } else if (this.fActiveInput != null) {
                newInput = true;
                this.fActiveInput = null;
                this.fActiveData = null;
                TableFilterController.this.fViewer.setItemCount(0);
                TableFilterController.this.fViewer.refresh(true);
            } else {
                return;
            }
            TableFilterController.this.notifyListeners(newInput);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        private int active2model(int index) {
            if (this.fActiveInput != null && index >= 0) {
                if (this.fActiveData != null) {
                    return index < this.fActiveData.length && this.fActiveData[index] < this.fActiveInput.size() ? this.fActiveData[index] : -1;
                }
                return index < this.fActiveInput.size() ? index : -1;
            }
            return -1;
        }

        private int model2active(int index) {
            if (this.fActiveInput != null && index >= 0) {
                if (this.fActiveData != null) {
                    int idx = Arrays.binarySearch(this.fActiveData, index);
                    return idx >= 0 ? idx : -1;
                }
                return index < this.fActiveInput.size() ? index : -1;
            }
            return -1;
        }

        public void updateElement(int index) {
            int idx = this.active2model(index);
            if (idx >= 0) {
                TableFilterController.this.fViewer.replace(this.fActiveInput.get(idx), index);
                return;
            }
        }
    }
}

