/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ecommons.coreutils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.osgi.framework.BundleContext;

public final class CoreMiscellanyPlugin
extends Plugin {
    public static final String BUNDLE_ID = "org.eclipse.statet.ecommons.coremisc";
    private static CoreMiscellanyPlugin instance;
    private boolean started;
    private final List<Disposable> disposables = new ArrayList<Disposable>();
    private SettingsChangeNotifier settingsNotifier;

    public static CoreMiscellanyPlugin getInstance() {
        return instance;
    }

    public static void log(IStatus status) {
        CoreMiscellanyPlugin plugin = CoreMiscellanyPlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public CoreMiscellanyPlugin() {
        instance = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
        CoreMiscellanyPlugin coreMiscellanyPlugin = this;
        synchronized (coreMiscellanyPlugin) {
            this.started = true;
            this.settingsNotifier = new SettingsChangeNotifier();
            this.addStoppingListener(this.settingsNotifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            CoreMiscellanyPlugin coreMiscellanyPlugin = this;
            synchronized (coreMiscellanyPlugin) {
                this.started = false;
            }
            try {
                for (Disposable listener : this.disposables) {
                    listener.dispose();
                }
            }
            finally {
                this.disposables.clear();
            }
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStoppingListener(Disposable listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        CoreMiscellanyPlugin coreMiscellanyPlugin = this;
        synchronized (coreMiscellanyPlugin) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.disposables.add(listener);
        }
    }

    public void removeStoppingListener(Disposable listener) {
        this.disposables.remove(listener);
    }

    public SettingsChangeNotifier getSettingsChangeNotifier() {
        return this.settingsNotifier;
    }
}

