/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.model.rpkg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.eclipse.statet.dsl.core.source.ast.DslAstNode;
import org.eclipse.statet.dsl.core.source.ast.SourceComponent;
import org.eclipse.statet.dsl.dcf.core.source.ast.DcfRecord;
import org.eclipse.statet.dsl.dcf.core.source.ast.EmbeddingValue;
import org.eclipse.statet.dsl.dcf.core.source.ast.Field;
import org.eclipse.statet.internal.r.core.model.rpkg.EmbeddingReconcileTask;
import org.eclipse.statet.internal.r.core.model.rpkg.RPkgDescrContainerSourceElement;
import org.eclipse.statet.internal.r.core.model.rpkg.RPkgDescrFieldSourceElement;
import org.eclipse.statet.internal.r.core.model.rpkg.RPkgDescrSourceUnitModelInfoImpl;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.r.core.model.RPkgDescriptions;

@NonNullByDefault
public class RPkgDescrSourceAnalyzer {
    private static final Integer ZERO = 0;
    private static final BiFunction<@Nullable String, @Nullable Integer, Integer> COUNTER = (key, count) -> count == null ? ZERO : Integer.valueOf(count + 1);
    private SourceUnit sourceUnit = (SourceUnit)ObjectUtils.nonNullLateInit();
    private AstInfo ast = (AstInfo)ObjectUtils.nonNullLateInit();
    private final List<RPkgDescrFieldSourceElement> recordBuilder = new ArrayList<RPkgDescrFieldSourceElement>();
    private final Map<@Nullable String, Integer> fieldNames = new HashMap<String, Integer>();
    private final List<EmbeddingReconcileTask> embeddedItems = new ArrayList<EmbeddingReconcileTask>();

    protected void clear() {
        this.embeddedItems.clear();
    }

    public RPkgDescrSourceUnitModelInfoImpl createModel(SourceUnit sourceUnit, AstInfo ast) {
        this.clear();
        try {
            RPkgDescrSourceUnitModelInfoImpl modelInfo;
            this.sourceUnit = sourceUnit;
            this.ast = ast;
            SourceComponent rootNode = (SourceComponent)ast.getRoot();
            RPkgDescrContainerSourceElement.SourceContainer element = new RPkgDescrContainerSourceElement.SourceContainer(this.sourceUnit, ast.getStamp(), (DslAstNode)rootNode);
            this.processSourceLines(element, rootNode);
            RPkgDescrSourceUnitModelInfoImpl rPkgDescrSourceUnitModelInfoImpl = modelInfo = new RPkgDescrSourceUnitModelInfoImpl(ast, element);
            return rPkgDescrSourceUnitModelInfoImpl;
        }
        finally {
            this.recordBuilder.clear();
            this.fieldNames.clear();
        }
    }

    public List<EmbeddingReconcileTask> getEmbeddedItems() {
        return this.embeddedItems;
    }

    private void processSourceLines(RPkgDescrContainerSourceElement element, SourceComponent sourceComponent) {
        int childIndex = 0;
        while (childIndex < sourceComponent.getChildCount()) {
            DslAstNode childNode = sourceComponent.getChild(childIndex);
            if (childNode instanceof DcfRecord) {
                this.createRecordElement(element, (DcfRecord)childNode);
            }
            ++childIndex;
        }
        element.children = ImCollections.toList(this.recordBuilder);
        this.recordBuilder.clear();
        this.fieldNames.clear();
    }

    private void createRecordElement(RPkgDescrContainerSourceElement parent, DcfRecord node) {
        ImIdentityList contentNodes = node.getContentNodes();
        int childIndex = 0;
        while (childIndex < contentNodes.size()) {
            DslAstNode childNode = (DslAstNode)contentNodes.get(childIndex);
            if (childNode instanceof Field) {
                this.createFieldElement(parent, (Field)childNode);
            }
            ++childIndex;
        }
    }

    private void createFieldElement(RPkgDescrContainerSourceElement parent, Field node) {
        String name;
        RPkgDescrFieldSourceElement element = new RPkgDescrFieldSourceElement(parent, node, name, (name = node.getKey().getText()) != null ? RPkgDescriptions.getFieldDefinition(name) : null);
        element.occurrenceCount = this.fieldNames.compute(name, COUNTER);
        this.recordBuilder.add(element);
        DslAstNode value = node.getValue();
        if (value instanceof EmbeddingValue) {
            this.embeddedItems.add(new EmbeddingReconcileTask((EmbeddingValue)value));
        }
    }
}

