/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.sourceediting;

import java.net.URI;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.statet.ecommons.net.resourcemapping.core.IResourceMapping;
import org.eclipse.statet.ecommons.net.resourcemapping.core.IResourceMappingManager;
import org.eclipse.statet.ecommons.net.resourcemapping.core.ResourceMappingOrder;
import org.eclipse.statet.ecommons.net.resourcemapping.core.ResourceMappingUtils;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.jcommons.text.core.input.OffsetStringParserInput;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.WorkspaceSourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.PathCompletionComputor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SourceProposal;
import org.eclipse.statet.nico.ui.console.ConsolePageEditor;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.core.RUtil;
import org.eclipse.statet.r.core.source.RLexer;
import org.eclipse.statet.r.core.source.RTerminal;

@NonNullByDefault
public class RPathCompletionComputer
extends PathCompletionComputor {
    private @Nullable RProcess associatedTool;
    private @Nullable IContainer baseResource;
    private @Nullable IFileStore baseFileStore;
    private final RLexer rLexer = new RLexer(16);

    public void onSessionStarted(SourceEditor editor, ContentAssist assist) {
        this.associatedTool = null;
        this.baseResource = null;
        this.baseFileStore = null;
        if (editor instanceof ConsolePageEditor) {
            Tool tool = (Tool)editor.getAdapter(Tool.class);
            if (tool instanceof RProcess) {
                this.associatedTool = (RProcess)tool;
            }
        } else {
            SourceUnit su = editor.getSourceUnit();
            if (su instanceof WorkspaceSourceUnit) {
                IContainer baseResource = null;
                IResource resource = ((WorkspaceSourceUnit)su).getResource();
                if (baseResource == null) {
                    baseResource = resource.getParent();
                }
                if (baseResource != null) {
                    try {
                        this.baseResource = baseResource;
                        this.baseFileStore = EFS.getStore((URI)baseResource.getLocationURI());
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
            }
        }
        super.onSessionStarted(editor, assist);
    }

    public void onSessionEnded() {
        super.onSessionEnded();
        this.associatedTool = null;
    }

    protected boolean getIsWindows() {
        RProcess associatedTool = this.associatedTool;
        if (associatedTool != null) {
            return associatedTool.getWorkspace().isWindows();
        }
        return super.getIsWindows();
    }

    protected char getDefaultFileSeparator() {
        RProcess associatedTool = this.associatedTool;
        if (associatedTool != null) {
            return associatedTool.getWorkspace().getFileSeparator();
        }
        return super.getDefaultFileSeparator();
    }

    protected @Nullable TextRegion getContentRegion(AssistInvocationContext context, int mode) throws BadLocationException {
        IDocument document = context.getSourceViewer().getDocument();
        int offset = context.getInvocationOffset();
        ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)context.getEditor().getDocumentContentInfo().getPartitioning(), (int)offset, (boolean)true);
        this.rLexer.reset((TextParserInput)new OffsetStringParserInput(document.get(partition.getOffset(), partition.getLength()), partition.getOffset()).init(partition.getOffset(), partition.getOffset() + partition.getLength()));
        switch (this.rLexer.next()) {
            case STRING_D: 
            case STRING_S: {
                return this.rLexer.getTextRegion();
            }
            case STRING_R: {
                return this.rLexer.getTextRegion();
            }
        }
        return null;
    }

    protected @Nullable IPath getRelativeBasePath() {
        RProcess associatedTool = this.associatedTool;
        if (associatedTool != null) {
            IFileStore wd = associatedTool.getWorkspace().getWorkspaceDir();
            if (wd != null) {
                return URIUtil.toPath((URI)wd.toURI());
            }
            return null;
        }
        IContainer baseResource = this.baseResource;
        if (baseResource != null) {
            return baseResource.getLocation();
        }
        return null;
    }

    protected @Nullable IFileStore getRelativeBaseStore() {
        RProcess associatedTool = this.associatedTool;
        if (associatedTool != null) {
            return associatedTool.getWorkspace().getWorkspaceDir();
        }
        IFileStore baseFileStore = this.baseFileStore;
        if (baseFileStore != null) {
            return baseFileStore;
        }
        return null;
    }

    protected @Nullable IFileStore resolveStore(IPath path) throws CoreException {
        RProcess associatedTool = this.associatedTool;
        if (associatedTool != null) {
            return associatedTool.getWorkspace().toFileStore(path);
        }
        return super.resolveStore(path);
    }

    protected void tryAlternative(AssistInvocationContext context, IPath path, int startOffset, String segmentPrefix, String completionPrefix, AssistProposalCollector proposals) throws CoreException {
        IResourceMappingManager rmManager;
        RProcess associatedTool = this.associatedTool;
        if (associatedTool != null && associatedTool.getWorkspace().isRemote() && (rmManager = ResourceMappingUtils.getManager()) != null) {
            SourceProposal.ProposalParameters parameters = this.createProposalParameters(context, startOffset, segmentPrefix);
            List mappings = rmManager.getResourceMappingsFor(associatedTool.getWorkspace().getHost(), ResourceMappingOrder.REMOTE);
            for (IResourceMapping mapping : mappings) {
                String name;
                IPath remotePath = mapping.getRemotePath();
                if (!path.isEmpty()) {
                    if (!path.isPrefixOf(remotePath)) continue;
                    remotePath = remotePath.setDevice(null).makeRelative().removeFirstSegments(path.segmentCount());
                }
                if ((name = remotePath.segment(0)) == null) {
                    name = "";
                }
                if (!parameters.matchesNamePattern(name)) continue;
                proposals.add((AssistProposal)new PathCompletionComputor.ResourceCompletionProposal((PathCompletionComputor)this, parameters, mapping.getFileStore(), remotePath.toString(), completionPrefix, null));
            }
            return;
        }
    }

    protected @Nullable String getPrefix(AssistInvocationContext context, TextRegion contentRegion, int offset) throws BadLocationException {
        if (this.rLexer.getType() == RTerminal.STRING_R) {
            return super.getPrefix(context, contentRegion, offset);
        }
        RLexer textLexer = new RLexer();
        TextParserInput input = this.rLexer.getInput();
        textLexer.reset(input.init(input.getStartIndex(), offset));
        switch (textLexer.next()) {
            case STRING_D: 
            case STRING_S: {
                return super.checkPrefix(textLexer.getText());
            }
        }
        return null;
    }

    protected String checkPathCompletion(IDocument document, int completionOffset, String completion) {
        boolean startsWithBackslash;
        if (this.rLexer.getType() == RTerminal.STRING_R) {
            return completion;
        }
        completion = RUtil.escapeCompletely((String)completion);
        int existingBackslashCount = 0;
        if (completionOffset >= 1) {
            try {
                if (document.getChar(completionOffset - 1) == '\\') {
                    ++existingBackslashCount;
                    if (completionOffset >= 2 && document.getChar(completionOffset - 2) == '\\') {
                        ++existingBackslashCount;
                    }
                }
            }
            catch (BadLocationException e) {
                RUIPlugin.logUncriticalError(e);
            }
        }
        boolean bl = startsWithBackslash = ((String)completion).length() >= 2 && ((String)completion).charAt(0) == '\\' && ((String)completion).charAt(1) == '\\';
        if (existingBackslashCount % 2 == 1) {
            completion = startsWithBackslash ? ((String)completion).substring(1, ((String)completion).length()) : "\\" + (String)completion;
        } else if (existingBackslashCount > 0 && startsWithBackslash) {
            completion = ((String)completion).substring(2, ((String)completion).length());
        }
        return completion;
    }
}

