/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.sourceediting;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.ui.assist.LinkedModeBracketLevel;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public final class RBracketLevel
extends LinkedModeBracketLevel {
    public RBracketLevel(LinkedModeModel model, IDocument document, DocContentSections documentContentInfo, LinkedModeBracketLevel.InBracketPosition position, boolean consoleMode, boolean autoDelete) {
        this(model, document, documentContentInfo, (List<? extends LinkedPosition>)ImCollections.newList((Object)position), (consoleMode ? 1 : 0) | (autoDelete ? 0x1000000 : 0));
    }

    public RBracketLevel(LinkedModeModel model, IDocument document, DocContentSections documentContentInfo, List<? extends LinkedPosition> positions, int mode) {
        super(model, document, documentContentInfo, positions, mode);
    }

    public static final class CurlyBracketPosition
    extends LinkedModeBracketLevel.InBracketPosition {
        public CurlyBracketPosition(IDocument doc, int offset, int length, int sequence) {
            super(doc, offset, length, sequence);
        }

        public char getOpenChar() {
            return '{';
        }

        public char getCloseChar() {
            return '}';
        }
    }

    public static final class OpSpecialPosition
    extends LinkedModeBracketLevel.InBracketPosition {
        public OpSpecialPosition(IDocument doc, int offset, int length, int sequence) {
            super(doc, offset, length, sequence);
        }

        public char getOpenChar() {
            return '%';
        }

        public char getCloseChar() {
            return '%';
        }

        public boolean insertCR(int charOffset) {
            return false;
        }

        public boolean matchesClose(LinkedModeBracketLevel level, int offset, char character) {
            return this.getOffset() + this.getLength() == offset && this.getCloseChar() == character;
        }
    }

    public static final class RoundBracketPosition
    extends LinkedModeBracketLevel.InBracketPosition {
        public RoundBracketPosition(IDocument doc, int offset, int length, int sequence) {
            super(doc, offset, length, sequence);
        }

        public char getOpenChar() {
            return '(';
        }

        public char getCloseChar() {
            return ')';
        }
    }

    public static final class SquareBracketPosition
    extends LinkedModeBracketLevel.InBracketPosition {
        public SquareBracketPosition(IDocument doc, int offset, int length, int sequence) {
            super(doc, offset, length, sequence);
        }

        public char getOpenChar() {
            return '[';
        }

        public char getCloseChar() {
            return ']';
        }
    }

    public static final class StringDPosition
    extends LinkedModeBracketLevel.InBracketPosition {
        public StringDPosition(IDocument doc, int offset, int length, int sequence) {
            super(doc, offset, length, sequence);
        }

        public char getOpenChar() {
            return '\"';
        }

        public char getCloseChar() {
            return '\"';
        }

        public boolean insertCR(int charOffset) {
            return false;
        }

        protected boolean isEscaped(int offset) throws BadLocationException {
            return TextUtil.countBackward((IDocument)this.getDocument(), (int)offset, (char)'\\') % 2 == 1;
        }
    }

    public static final class StringRCurlyPosition
    extends StringRPosition {
        public StringRCurlyPosition(int nDashes, IDocument doc, int offset, int length, int sequence) {
            super(nDashes, doc, offset, length, sequence);
        }

        public char getOpenChar() {
            return '{';
        }

        public char getCloseChar() {
            return '}';
        }
    }

    protected static abstract class StringRPosition
    extends LinkedModeBracketLevel.InBracketPosition {
        private final int closeLength;

        public StringRPosition(int nDashes, IDocument doc, int offset, int length, int sequence) {
            super(doc, offset, length, sequence);
            this.closeLength = 2 + nDashes;
        }

        protected int getCloseLength() {
            return this.closeLength;
        }
    }

    public static final class StringRRoundPosition
    extends StringRPosition {
        public StringRRoundPosition(int nDashes, IDocument doc, int offset, int length, int sequence) {
            super(nDashes, doc, offset, length, sequence);
        }

        public char getOpenChar() {
            return '(';
        }

        public char getCloseChar() {
            return ')';
        }
    }

    public static final class StringRSquarePosition
    extends StringRPosition {
        public StringRSquarePosition(int nDashes, IDocument doc, int offset, int length, int sequence) {
            super(nDashes, doc, offset, length, sequence);
        }

        public char getOpenChar() {
            return '[';
        }

        public char getCloseChar() {
            return ']';
        }
    }

    public static final class StringSPosition
    extends LinkedModeBracketLevel.InBracketPosition {
        public StringSPosition(IDocument doc, int offset, int length, int sequence) {
            super(doc, offset, length, sequence);
        }

        public char getOpenChar() {
            return '\'';
        }

        public char getCloseChar() {
            return '\'';
        }

        public boolean insertCR(int charOffset) {
            return false;
        }

        protected boolean isEscaped(int offset) throws BadLocationException {
            return TextUtil.countBackward((IDocument)this.getDocument(), (int)offset, (char)'\\') % 2 == 1;
        }
    }

    public static final class SymbolGPosition
    extends LinkedModeBracketLevel.InBracketPosition {
        public SymbolGPosition(IDocument doc, int offset, int length, int sequence) {
            super(doc, offset, length, sequence);
        }

        public char getOpenChar() {
            return '`';
        }

        public char getCloseChar() {
            return '`';
        }

        public boolean insertCR(int charOffset) {
            return false;
        }

        protected boolean isEscaped(int offset) throws BadLocationException {
            return TextUtil.countBackward((IDocument)this.getDocument(), (int)offset, (char)'\\') % 2 == 1;
        }
    }
}

