/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.launching;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.debug.ui.RLaunchingMessages;
import org.eclipse.statet.internal.r.ui.help.EnrichedRHelpContext;
import org.eclipse.statet.r.launching.RCodeLaunching;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class AbstractRCommandHandler
extends AbstractHandler {
    private final String fName;

    public static String createCommandString(String commandId, String[][] parameters) throws NotDefinedException {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command base = service.getCommand(commandId);
        if (base == null) {
            throw new NotDefinedException("No command registered with the requested id: " + commandId);
        }
        Parameterization[] par = new Parameterization[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            par[i] = new Parameterization(base.getParameter(parameters[i][0]), parameters[i][1]);
            ++i;
        }
        ParameterizedCommand configured = new ParameterizedCommand(base, par);
        return configured.serialize();
    }

    protected AbstractRCommandHandler(String commandName) {
        this.fName = commandName;
    }

    protected String getRSelection() {
        final AtomicReference topic = new AtomicReference();
        UIAccess.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                topic.set(EnrichedRHelpContext.searchContextInfo(UIAccess.getActiveWorkbenchPage((boolean)true).getActivePart()));
                if (topic.get() == null) {
                    Display.getCurrent().beep();
                }
            }
        });
        return (String)topic.get();
    }

    protected void runCommand(String cmd, boolean gotoConsole) {
        try {
            RCodeLaunching.runRCodeDirect(Collections.singletonList(cmd), gotoConsole, null);
        }
        catch (CoreException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", -1, NLS.bind((String)RLaunchingMessages.RSpecifiedLaunch_error_message, (Object)this.fName), (Throwable)e), 3);
        }
    }
}

