/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.pkgmanager;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Collection;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.pkgmanager.IRPkgData;
import org.eclipse.statet.rj.renv.core.RPkgCompilation;
import org.eclipse.statet.rj.renv.core.RPkgList;

@NonNullByDefault
class Util {
    Util() {
    }

    public static @Nullable IRPkgData getPkgByRepo(RPkgCompilation<? extends IRPkgData> collection, String name, @Nullable String repoId) {
        if (repoId != null) {
            for (RPkgList list : collection.getAll()) {
                IRPkgData pkg = (IRPkgData)list.get(name);
                if (pkg == null || !repoId.equals(pkg.getRepoId())) continue;
                return pkg;
            }
        }
        return null;
    }

    public static boolean hasPkgPriority(RPkgCompilation<? extends IRPkgData> collection, String name, Collection<?> priorities) {
        for (RPkgList list : collection.getAll()) {
            IRPkgData pkg = (IRPkgData)list.get(name);
            if (pkg == null || !priorities.contains(pkg.getPriority())) continue;
            return true;
        }
        return false;
    }

    public static String formatTimestamp(@Nullable Instant stamp) {
        if (stamp == null) {
            return "-";
        }
        return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.SHORT).format(LocalDateTime.ofInstant(stamp, ZoneOffset.systemDefault()));
    }
}

