/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core.index;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.rhelp.core.RHelpSearchMatch;

@NonNullByDefault
public class RHelpHtmlUtils {
    public static final String HR_PREFIX = "<hr";
    public static final Pattern HR_LINE_PATTERN = Pattern.compile("\\A\\Q<hr\\E\\ ?\\Q/>\\E");
    public static final String MATCH_HIGHTLIGHT_CLASS_PREFIX = "SMATCH-";
    private static final Pattern START_TAG_PATTERN = Pattern.compile("\\A\\<SMATCH\\-([A-J])\\>");

    public static final int indexOfLastHr(String html) {
        Matcher matcher = null;
        int idx = html.length();
        while ((idx = html.lastIndexOf(HR_PREFIX, idx - 1)) != -1) {
            if (matcher == null) {
                matcher = HR_LINE_PATTERN.matcher(html);
            }
            matcher.region(idx, html.length());
            if (!matcher.find()) continue;
            return idx;
        }
        return -1;
    }

    public static final int indexOfSectionEnd(String html, int idxBegin) {
        int idx = html.indexOf("<h3", idxBegin);
        return idx;
    }

    public static String formatHtmlMatches(String html) {
        StringBuilder sb = new StringBuilder(html.length() + 64);
        Matcher startMatcher = START_TAG_PATTERN.matcher(html);
        int idx = 0;
        int beginIdx = 0;
        while (idx < html.length()) {
            int nextIdx = html.indexOf(60, idx);
            if (nextIdx != -1 && startMatcher.region(nextIdx, html.length()).find()) {
                sb.append(html, beginIdx, nextIdx);
                beginIdx = idx = RHelpHtmlUtils.formatHtmlMatch(startMatcher.group(1).charAt(0), html, startMatcher.end(), sb);
                continue;
            }
            ++idx;
        }
        sb.append(html, beginIdx, html.length());
        return sb.toString();
    }

    private static int formatHtmlMatch(char matchClass, String html, int beginIdx, StringBuilder sb) {
        int endIdx = html.indexOf(RHelpSearchMatch.POST_TAGS[matchClass - 65], beginIdx);
        if (endIdx == -1) {
            return beginIdx;
        }
        sb.append("<span class=\"");
        sb.append(MATCH_HIGHTLIGHT_CLASS_PREFIX);
        sb.append(matchClass);
        sb.append("\">");
        sb.append(html, beginIdx, endIdx);
        sb.append("</span>");
        return endIdx + "</SMATCH-".length() + 2;
    }
}

