/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.style.editor;

import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.config.DisplayMode;
import org.eclipse.statet.ecommons.waltable.core.style.CellStyling;
import org.eclipse.statet.ecommons.waltable.core.style.Style;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class GridStyleParameterObject {
    public Font tableFont;
    public Color evenRowColor;
    public Color oddRowColor;
    public Color selectionColor;
    public Style evenRowStyle;
    public Style oddRowStyle;
    public Style selectionStyle;
    public Style tableStyle;
    private final ConfigRegistry configRegistry;

    public GridStyleParameterObject(ConfigRegistry configRegistry) {
        this.configRegistry = configRegistry;
        this.init(configRegistry);
    }

    private void init(ConfigRegistry configRegistry) {
        this.evenRowStyle = configRegistry.getAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "BODY_EVEN_ROW");
        this.evenRowColor = this.evenRowStyle.getAttributeValue(CellStyling.BACKGROUND_COLOR);
        this.oddRowStyle = configRegistry.getAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "BODY_ODD_ROW");
        this.oddRowColor = this.oddRowStyle.getAttributeValue(CellStyling.BACKGROUND_COLOR);
        this.selectionStyle = configRegistry.getAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.SELECTED, new String[0]);
        this.selectionColor = this.selectionStyle.getAttributeValue(CellStyling.BACKGROUND_COLOR);
        this.tableStyle = configRegistry.getAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, new String[0]);
        this.tableFont = this.tableStyle.getAttributeValue(CellStyling.FONT);
    }

    public ConfigRegistry getConfigRegistry() {
        return this.configRegistry;
    }
}

