/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.resize.core;

import org.eclipse.statet.ecommons.waltable.core.command.AbstractLayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerUtils;
import org.eclipse.statet.ecommons.waltable.resize.core.AutoResizePositionsCommand;
import org.eclipse.statet.ecommons.waltable.resize.core.InitializeAutoResizeCommand;
import org.eclipse.statet.ecommons.waltable.selection.core.SelectionLayer;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class InitializeAutoResizeCommandHandler
extends AbstractLayerCommandHandler<InitializeAutoResizeCommand> {
    private final SelectionLayer selectionLayer;

    public InitializeAutoResizeCommandHandler(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    @Override
    public Class<InitializeAutoResizeCommand> getCommandClass() {
        return InitializeAutoResizeCommand.class;
    }

    @Override
    protected boolean doCommand(InitializeAutoResizeCommand initCommand) {
        long position;
        LayerDim layerDim = initCommand.getDim();
        long selectionPosition = LayerUtils.convertPosition(layerDim, position = initCommand.getPosition(), position, this.selectionLayer.getDim(layerDim.getOrientation()));
        if (selectionPosition != Long.MIN_VALUE && this.selectionLayer.isPositionFullySelected(layerDim.getOrientation(), position)) {
            LRangeList positions = this.selectionLayer.getFullySelectedPositions(layerDim.getOrientation());
            this.selectionLayer.doCommand(new AutoResizePositionsCommand((LayerDim)this.selectionLayer.getDim(layerDim.getOrientation()), positions));
        } else {
            LRangeList positions = new LRangeList(position);
            layerDim.getLayer().doCommand(new AutoResizePositionsCommand(layerDim, positions));
        }
        return true;
    }
}

