/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.dbg;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RJIOExternalizable;
import org.eclipse.statet.rj.server.dbg.Tracepoint;

@NonNullByDefault
public class TracepointPosition
implements Tracepoint,
Comparable<TracepointPosition>,
RJIOExternalizable {
    private final int type;
    private final long id;
    private final int[] exprIndex;
    private final int[] @Nullable [] exprSrcrefs;

    public TracepointPosition(int type, long id, int[] index) {
        this.type = type;
        this.id = id;
        this.exprIndex = (int[])ObjectUtils.nonNullAssert((Object)index);
        this.exprSrcrefs = new int[this.exprIndex.length][];
    }

    public TracepointPosition(int type, long id, int[] index, int @Nullable [] srcref) {
        this.type = type;
        this.id = id;
        this.exprIndex = (int[])ObjectUtils.nonNullAssert((Object)index);
        this.exprSrcrefs = new int[this.exprIndex.length][];
        this.exprSrcrefs[this.exprSrcrefs.length - 1] = srcref;
    }

    TracepointPosition(RJIO io) throws IOException {
        this.type = io.readInt();
        this.id = io.readLong();
        this.exprIndex = (int[])ObjectUtils.nonNullAssert((Object)io.readIntArray());
        this.exprSrcrefs = new int[this.exprIndex.length][];
        int i = 0;
        while (i < this.exprSrcrefs.length) {
            this.exprSrcrefs[i] = io.readIntArray();
            ++i;
        }
    }

    public void writeExternal(RJIO io) throws IOException {
        io.writeInt(this.type);
        io.writeLong(this.id);
        io.writeIntArray(this.exprIndex, this.exprIndex.length);
        int i = 0;
        while (i < this.exprSrcrefs.length) {
            int[] srcref;
            io.writeIntArray(srcref, (srcref = this.exprSrcrefs[i]) != null ? 6 : -1);
            ++i;
        }
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public int[] getIndex() {
        return this.exprIndex;
    }

    public int[] @Nullable [] getSrcrefs() {
        return this.exprSrcrefs;
    }

    public int @Nullable [] getSrcref(int level) {
        return this.exprSrcrefs[level];
    }

    public int @Nullable [] getSrcref() {
        return this.exprSrcrefs.length > 0 ? this.exprSrcrefs[this.exprSrcrefs.length - 1] : null;
    }

    @Override
    public int compareTo(TracepointPosition other) {
        int i = 0;
        while (i < this.exprIndex.length) {
            if (i < other.exprIndex.length) {
                int diff = this.exprIndex[i] - other.exprIndex[i];
                if (diff != 0) {
                    return diff;
                }
            } else {
                return 1;
            }
            ++i;
        }
        if (this.exprIndex.length != other.exprIndex.length) {
            return -1;
        }
        return this.type - other.type;
    }

    public int hashCode() {
        int h = this.type;
        int i = 0;
        while (i < this.exprIndex.length) {
            h = this.exprIndex[i] * 128 * (i + 1) ^ 2;
            ++i;
        }
        return h;
    }

    public boolean equals(@Nullable Object obj) {
        block2: {
            block3: {
                if (obj == this) break block2;
                if (!(obj instanceof TracepointPosition)) break block3;
                TracepointPosition other = (TracepointPosition)obj;
                if (this.type == other.type && Arrays.equals(this.exprIndex, other.exprIndex)) break block2;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TracepointPosition");
        sb.append(" (type= ").append(this.type).append(")");
        sb.append("\n\texprIndex= ").append(Arrays.toString(this.exprIndex));
        sb.append("\n\texprSrcref= ").append(Arrays.toString(this.getSrcref()));
        return sb.toString();
    }
}

