/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.ui.sourceediting;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.ecommons.text.IndentUtil;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartition;
import org.eclipse.statet.ecommons.text.ui.assist.LinkedModeBracketLevel;
import org.eclipse.statet.ecommons.ui.ISettingsChangedHandler;
import org.eclipse.statet.internal.yaml.ui.editors.YamlBracketLevel;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.string.CharPair;
import org.eclipse.statet.jcommons.string.Chars;
import org.eclipse.statet.jcommons.text.core.CharPairSet;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.sourceediting.AbstractAutoEditStrategy;
import org.eclipse.statet.ltk.ui.sourceediting.SmartInsertSettings;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.yaml.core.YamlCodeStyleSettings;
import org.eclipse.statet.yaml.core.YamlCoreAccess;
import org.eclipse.statet.yaml.core.source.doc.YamlDocumentConstants;
import org.eclipse.statet.yaml.core.source.doc.YamlPartitionNodeType;
import org.eclipse.statet.yaml.core.source.util.YamlHeuristicTokenScanner;
import org.eclipse.statet.yaml.ui.sourceediting.YamlEditingSettings;
import org.eclipse.swt.events.KeyEvent;

public class YamlAutoEditStrategy
extends AbstractAutoEditStrategy {
    private final YamlCoreAccess yamlCoreAccess;
    private final Settings settings;
    private YamlHeuristicTokenScanner scanner;
    private YamlCodeStyleSettings codeStyle;

    public YamlAutoEditStrategy(YamlCoreAccess coreAccess, SourceEditor editor) {
        super(editor);
        assert (coreAccess != null);
        this.yamlCoreAccess = coreAccess;
        this.settings = new Settings(coreAccess);
    }

    public Settings getSettings() {
        return this.settings;
    }

    protected IIndentSettings getCodeStyleSettings() {
        return this.codeStyle;
    }

    protected final TreePartition initCustomization(int offset, int ch) throws BadLocationException, BadPartitioningException {
        if (this.scanner == null) {
            this.scanner = this.createScanner();
        }
        this.codeStyle = this.yamlCoreAccess.getYamlCodeStyle();
        return super.initCustomization(offset, ch);
    }

    protected YamlHeuristicTokenScanner createScanner() {
        return YamlHeuristicTokenScanner.create((DocContentSections)this.getDocumentContentInfo());
    }

    /*
     * Unable to fully structure code
     */
    protected TextRegion computeValidRange(int offset, TreePartition partition, int ch) {
        block1: {
            node = partition.getTreeNode();
            if (!(node.getType() instanceof YamlPartitionNodeType)) break block1;
            if (this.getDocumentContentInfo().getPrimaryType() != "org.eclipse.statet.Yaml") ** GOTO lbl6
            return super.computeValidRange(offset, partition, ch);
lbl-1000:
            // 1 sources

            {
                node = parent;
lbl6:
                // 2 sources

                ** while ((parent = node.getParent()) != null && parent instanceof YamlPartitionNodeType)
            }
lbl7:
            // 1 sources

            return node;
        }
        return null;
    }

    protected YamlHeuristicTokenScanner getScanner() {
        return this.scanner;
    }

    protected final void quitCustomization() {
        super.quitCustomization();
        this.codeStyle = null;
    }

    private final boolean isClosedBracket(int backwardOffset, int forwardOffset, String currentPartition, CharPair searchType) throws BadLocationException {
        CharPairSet brackets = YamlHeuristicTokenScanner.YAML_BRACKETS;
        int searchPairIndex = brackets.getPairIndex(searchType);
        int[] balance = new int[brackets.getPairCount()];
        int n = searchPairIndex;
        balance[n] = balance[n] + 1;
        this.scanner.configure((IDocument)this.getDocument(), currentPartition);
        balance = this.scanner.computePairBalance(backwardOffset, forwardOffset, this.getValidRange(), brackets, balance, searchPairIndex);
        return balance[searchPairIndex] <= 0;
    }

    private final boolean isClosedQuotedD(int offset, int end, boolean endVirtual) throws BadLocationException {
        this.scanner.configure((IDocument)this.getDocument());
        boolean in = true;
        char[] chars = new char[]{'\"', '\\'};
        while (offset < end) {
            if ((offset = this.scanner.scanForward(offset, end, chars)) == -1) {
                offset = end;
                break;
            }
            ++offset;
            if (this.scanner.getChar() == '\\') {
                ++offset;
                continue;
            }
            boolean bl = in = !in;
        }
        return offset == end && !in ^ endVirtual;
    }

    private boolean isValueChar(int offset) throws BadLocationException {
        int ch = this.getChar(offset);
        return ch != -1 && Character.isLetterOrDigit(ch);
    }

    protected char isCustomizeKey(KeyEvent event) {
        switch (event.character) {
            case '\"': 
            case '\'': 
            case '[': 
            case '{': {
                return event.character;
            }
            case '\t': {
                if (event.stateMask != 0) break;
                return '\t';
            }
            case '\n': 
            case '\r': {
                if (this.getEditor3() == null) break;
                return '\n';
            }
        }
        return '\u0000';
    }

    protected void doCustomizeKeyCommand(char ch, DocumentCommand command, TreePartition partition) throws Exception {
        String contentType = partition.getType();
        int cEnd = command.offset + command.length;
        int linkedModeType = -1;
        int linkedModeOffset = -1;
        switch (ch) {
            case '\t': {
                if (YamlDocumentConstants.YAML_ANY_CONTENT_CONSTRAINT.matches(contentType) && this.isRegularTabCommand(command)) {
                    command.text = "\t";
                    this.smartInsertOnTab(command, true);
                    break;
                }
                return;
            }
            case '[': {
                if (YamlDocumentConstants.YAML_DEFAULT_CONTENT_CONSTRAINT.matches(contentType)) {
                    command.text = "[";
                    if (!this.settings.closeBrackets || this.isValueChar(cEnd)) break;
                    if (!this.isClosedBracket(command.offset, cEnd, contentType, Chars.SQUARE_BRACKETS)) {
                        command.text = "[]";
                        linkedModeType = 0x1000002;
                        break;
                    }
                    if (this.getChar(cEnd) != 93) break;
                    linkedModeType = 2;
                    break;
                }
                return;
            }
            case '{': {
                if (YamlDocumentConstants.YAML_DEFAULT_CONTENT_CONSTRAINT.matches(contentType)) {
                    command.text = "{";
                    if (!this.settings.closeBrackets || this.isValueChar(cEnd)) break;
                    if (!this.isClosedBracket(command.offset, cEnd, contentType, Chars.CURLY_BRACKETS)) {
                        command.text = "{}";
                        linkedModeType = 0x1000002;
                        break;
                    }
                    if (this.getChar(cEnd) != 125) break;
                    linkedModeType = 2;
                    break;
                }
                return;
            }
            case '\"': {
                IRegion line;
                if (YamlDocumentConstants.YAML_DEFAULT_CONTENT_CONSTRAINT.matches(contentType) && this.settings.closeQuotes && !this.isValueChar(cEnd) && !this.isValueChar(command.offset - 1)) {
                    line = this.getDocument().getLineInformationOfOffset(cEnd);
                    if (this.isClosedQuotedD(cEnd, line.getOffset() + line.getLength(), false)) break;
                    command.text = "\"\"";
                    linkedModeType = 0x1000002;
                    break;
                }
                return;
            }
            case '\'': {
                IRegion line;
                if (YamlDocumentConstants.YAML_DEFAULT_CONTENT_CONSTRAINT.matches(contentType) && this.settings.closeQuotes && !this.isValueChar(cEnd) && !this.isValueChar(command.offset - 1)) {
                    line = this.getDocument().getLineInformationOfOffset(cEnd);
                    if (this.isClosedQuotedD(cEnd, line.getOffset() + line.getLength(), false)) break;
                    command.text = "''";
                    linkedModeType = 0x1000002;
                    break;
                }
                return;
            }
            case '\n': {
                if (YamlDocumentConstants.YAML_DEFAULT_CONTENT_CONSTRAINT.matches(contentType) || contentType == "Yaml.Comment" && YamlDocumentConstants.YAML_DEFAULT_CONTENT_CONSTRAINT.matches(partition.getTreeNode().getParent().getType().getPartitionType())) {
                    command.text = TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocument());
                    this.smartIndentOnNewLine(command, contentType);
                    break;
                }
                return;
            }
            default: {
                assert (false);
                return;
            }
        }
        if (command.doit && command.text.length() > 0 && this.getEditor().isEditable(true)) {
            this.getViewer().getTextWidget().setRedraw(false);
            try {
                this.applyCommand(command);
                this.updateSelection(command);
                if (linkedModeType >= 0) {
                    if (linkedModeOffset < 0) {
                        linkedModeOffset = command.offset;
                    }
                    this.createLinkedMode(linkedModeOffset, ch, linkedModeType).enter();
                }
            }
            finally {
                this.getViewer().getTextWidget().setRedraw(true);
            }
        }
    }

    protected void doCustomizeOtherCommand(DocumentCommand command, TreePartition partition) throws Exception {
        String contentType = partition.getType();
        if (YamlDocumentConstants.YAML_DEFAULT_CONTENT_CONSTRAINT.matches(contentType) && command.length == 0 && TextUtilities.equals((String[])this.getDocument().getLegalLineDelimiters(), (String)command.text) != -1) {
            this.smartIndentOnNewLine(command, contentType);
        }
    }

    private void smartIndentOnNewLine(DocumentCommand command, String partitionType) throws Exception {
        int cBefore;
        String lineDelimiter = command.text;
        if (YamlDocumentConstants.YAML_DEFAULT_CONTENT_CONSTRAINT.matches(partitionType) && ((cBefore = this.getChar(command.offset - 1)) == 91 && this.getChar(command.offset + command.length) == 93 || cBefore == 123 && this.getChar(command.offset + command.length) == 125)) {
            command.text = command.text + command.text;
        }
        this.smartIndentAfterNewLine1(command, lineDelimiter);
    }

    private void smartIndentAfterNewLine1(DocumentCommand command, String lineDelimiter) throws BadLocationException, BadPartitioningException, CoreException {
        AbstractDocument doc = this.getDocument();
        StringBuilder sb = new StringBuilder(command.text);
        int nlIndex = lineDelimiter.length();
        int line = doc.getLineOfOffset(command.offset);
        int checkOffset = Math.max(0, command.offset);
        ITypedRegion partition = doc.getPartition(this.scanner.getDocumentPartitioning(), checkOffset, true);
        if (partition.getType() == "Yaml.Comment") {
            checkOffset = partition.getOffset();
        }
        IndentUtil util = new IndentUtil((IDocument)doc, (IIndentSettings)this.codeStyle);
        int column = util.getLineIndent(line, false)[0];
        if (checkOffset > 0) {
            char cBefore;
            this.scanner.configure((IDocument)doc);
            int match = this.scanner.findAnyNonSSpaceBackward(checkOffset, doc.getLineOffset(line));
            if (match != -1 && ((cBefore = doc.getChar(match)) == '[' || cBefore == '{')) {
                String indent = util.createIndentString(util.getNextLevelColumn(column, 1));
                sb.insert(nlIndex, indent);
                nlIndex += indent.length() + lineDelimiter.length();
            }
        }
        if (nlIndex <= sb.length()) {
            sb.insert(nlIndex, util.createIndentString(column));
        }
        command.text = sb.toString();
    }

    private LinkedModeUI createLinkedMode(int offset, char type, int mode) throws BadLocationException {
        LinkedModeModel model = new LinkedModeModel();
        int pos = 0;
        LinkedPositionGroup group = new LinkedPositionGroup();
        LinkedModeBracketLevel.InBracketPosition position = YamlBracketLevel.createPosition(type, (IDocument)this.getDocument(), offset + 1, 0, pos++);
        group.addPosition((LinkedPosition)position);
        model.addGroup(group);
        model.forceInstall();
        YamlBracketLevel level = new YamlBracketLevel(model, (IDocument)this.getDocument(), this.getDocumentContentInfo(), (List<? extends LinkedPosition>)ImCollections.newList((Object)position), mode & 0xFFFF0000);
        LinkedModeUI ui = new LinkedModeUI(model, (ITextViewer)this.getViewer());
        ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
        ui.setExitPosition((ITextViewer)this.getViewer(), offset + (mode & 0xFF), 0, pos);
        ui.setSimpleMode(true);
        ui.setExitPolicy((LinkedModeUI.IExitPolicy)level);
        return ui;
    }

    public static class Settings
    implements SmartInsertSettings,
    ISettingsChangedHandler {
        private final YamlCoreAccess coreAccess;
        private boolean enabledByDefault;
        private SmartInsertSettings.TabAction tabAction;
        private boolean closeBrackets;
        private boolean closeQuotes;

        public Settings(YamlCoreAccess coreAccess) {
            this.coreAccess = coreAccess;
            this.updateSettings();
        }

        public void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
            if (groupIds == null || groupIds.contains("yaml/editor/smartinsert")) {
                this.updateSettings();
            }
        }

        private void updateSettings() {
            PreferenceAccess prefs = this.coreAccess.getPrefs();
            this.enabledByDefault = (Boolean)prefs.getPreferenceValue(YamlEditingSettings.SMARTINSERT_BYDEFAULT_ENABLED_PREF);
            this.tabAction = (SmartInsertSettings.TabAction)prefs.getPreferenceValue(YamlEditingSettings.SMARTINSERT_TAB_ACTION_PREF);
            this.closeBrackets = (Boolean)prefs.getPreferenceValue(YamlEditingSettings.SMARTINSERT_CLOSEBRACKETS_ENABLED_PREF);
            this.closeQuotes = (Boolean)prefs.getPreferenceValue(YamlEditingSettings.SMARTINSERT_CLOSEQUOTES_ENABLED_PREF);
        }

        public boolean isSmartInsertEnabledByDefault() {
            return this.enabledByDefault;
        }

        public SmartInsertSettings.TabAction getSmartInsertTabAction() {
            return this.tabAction;
        }
    }
}

