/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.string;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public final class CharArrayString
implements CharSequence {
    private static final char[] EMPTY_ARRAY = new char[0];
    private char[] array;
    private int offset;
    private int length;
    private int hashCode;

    public CharArrayString() {
        this.array = EMPTY_ARRAY;
    }

    public CharArrayString(char[] array, int offset, int length) {
        this.set(array, offset, length);
    }

    public CharArrayString(char[] array) {
        this.set(array, 0, array.length);
    }

    public CharArrayString(String s) {
        this.set(s);
    }

    public void clear() {
        this.array = EMPTY_ARRAY;
        this.hashCode = 0;
        this.length = 0;
        this.offset = 0;
    }

    public void set(char[] array) {
        this.array = array;
        this.offset = 0;
        this.length = array.length;
        this.hashCode = 0;
    }

    public void set(char[] array, int offset, int length) {
        this.array = array;
        this.offset = offset;
        this.length = length;
        this.hashCode = 0;
    }

    public void set(String s) {
        this.array = s.toCharArray();
        this.offset = 0;
        this.length = this.array.length;
        this.hashCode = s.hashCode();
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        return this.array[this.offset + index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new CharArrayString(this.array, this.offset + start, end - start);
    }

    public int hashCode() {
        int hashCode = this.hashCode;
        if (hashCode == 0) {
            int length = this.length;
            char[] array = this.array;
            int offset = this.offset;
            while (length-- != 0) {
                hashCode = 31 * hashCode + array[offset++];
            }
        }
        return hashCode;
    }

    public boolean contentEquals(String s) {
        int length = this.length;
        if (length != s.length() || this.hashCode != 0 && this.hashCode != s.hashCode()) {
            return false;
        }
        char[] array = this.array;
        int offset = this.offset;
        int i = 0;
        while (length-- != 0) {
            if (array[offset++] == s.charAt(i++)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CharArrayString) {
            CharArrayString other = (CharArrayString)obj;
            int length = this.length;
            if (length != other.length || this.hashCode != 0 && other.hashCode != 0 && this.hashCode != other.hashCode) {
                return false;
            }
            char[] array1 = this.array;
            int offset1 = this.offset;
            char[] array2 = other.array;
            int offset2 = other.offset;
            while (length-- > 0) {
                if (array1[offset1++] == array2[offset2++]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return new String(this.array, this.offset, this.length);
    }
}

