/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.net.core;

import java.time.Duration;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.CancelStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;

@NonNullByDefault
public abstract class RemoteProcess
implements AutoCloseable {
    public static final int MISSING_EXIT_STATUS_CODE = -1;
    private final String command;

    public RemoteProcess(String command) {
        this.command = command;
    }

    public abstract boolean isAlive();

    public boolean waitFor(@Nullable Duration timeout) throws InterruptedException {
        if (timeout == null) {
            while (this.isAlive()) {
                Thread.sleep(50L);
            }
            return true;
        }
        long timeoutTime = System.nanoTime() + timeout.toNanos();
        while (this.isAlive()) {
            long remaining = timeoutTime - System.nanoTime();
            if (remaining <= 0L) {
                return false;
            }
            Thread.sleep(Math.min(remaining / 1000000L, 50L));
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public int waitFor(@Nullable Duration timeout, ProgressMonitor m) throws StatusException {
        if (timeout == null) ** GOTO lbl23
        timeoutTime = System.nanoTime() + timeout.toNanos();
        while (this.isAlive()) {
            if (m.isCanceled()) {
                throw this.newCancelException();
            }
            remaining = timeoutTime - System.nanoTime();
            if (remaining <= 0L) {
                throw this.newTimeoutException(timeout);
            }
            try {
                Thread.sleep(Math.min(remaining / 1000000L, 50L));
            }
            catch (InterruptedException var7_6) {
                // empty catch block
            }
        }
        return this.getExitStatusCode();
lbl-1000:
        // 1 sources

        {
            if (m.isCanceled()) {
                throw this.newCancelException();
            }
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException var3_4) {
                // empty catch block
            }
lbl23:
            // 3 sources

            ** while (this.isAlive())
        }
lbl24:
        // 1 sources

        return this.getExitStatusCode();
    }

    public abstract int getExitStatusCode();

    @Override
    public abstract void close();

    protected StatusException newCancelException() {
        return new StatusException(Status.CANCEL_STATUS);
    }

    protected StatusException newTimeoutException(Duration timeout) {
        return new StatusException(new CancelStatus("org.eclipse.statet.jcommons.util", String.format("The process has not exited within the specified timeout (%1$s).", timeout)));
    }
}

