/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.net.core;

import java.net.InetSocketAddress;
import java.net.Socket;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.net.CommonsNet;
import org.eclipse.statet.jcommons.net.Port;
import org.eclipse.statet.jcommons.net.core.PortForwardingL;
import org.eclipse.statet.jcommons.net.core.RemoteProcess;
import org.eclipse.statet.jcommons.net.core.RemoteTarget;
import org.eclipse.statet.jcommons.runtime.ProcessConfig;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;

@NonNullByDefault
public interface RSAccessClientSession {
    public RemoteTarget getTarget();

    public void addListener(Listener var1);

    public void removeListener(Listener var1);

    default public String getTargetLocalhostString() {
        return CommonsNet.LOOPBACK_STRING;
    }

    public boolean isConnected();

    public void disconnect();

    public RemoteProcess exec(ProcessConfig var1, ProgressMonitor var2) throws StatusException;

    public Socket createDirectTcpIpSocket(InetSocketAddress var1, ProgressMonitor var2) throws StatusException;

    public Socket createDirectTcpIpSocket(Port var1, ProgressMonitor var2) throws StatusException;

    public PortForwardingL allocatePortForwardingL(InetSocketAddress var1) throws StatusException;

    public PortForwardingL allocatePortForwardingL(Port var1) throws StatusException;

    public void releasePortForwarding(PortForwardingL var1) throws StatusException;

    public static class Event {
        private final Type type;
        private final RSAccessClientSession session;

        public Event(Type type, RSAccessClientSession session) {
            this.type = type;
            this.session = session;
        }

        public Type getType() {
            return this.type;
        }

        public RSAccessClientSession getSession() {
            return this.session;
        }

        public String toString() {
            return this.type.toString();
        }

        public static enum Type {
            DISCONNECT;

        }
    }

    public static interface Listener {
        public void onSessionChanged(Event var1);
    }
}

