/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.collections;

import java.util.Map;
import java.util.Objects;
import org.eclipse.statet.jcommons.collections.ImMapEntry;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class BasicImMapEntry<@NonNull K, V>
implements ImMapEntry<K, V> {
    private final K key;
    private final V value;

    public BasicImMapEntry(K key, V value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public final K getKey() {
        return this.key;
    }

    @Override
    public final V getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        Map.Entry other;
        return this == obj || obj instanceof Map.Entry && this.key.equals((other = (Map.Entry)obj).getKey()) && Objects.equals(this.value, other.getValue());
    }

    public String toString() {
        V value = this.value;
        return String.format("%1$s= %2$s", this.key, value != null ? value : "<null>");
    }
}

