/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.core.source.doc;

import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.Locator;
import org.eclipse.statet.docmlet.wikitext.core.markup.MarkupParser2;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextLocator;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.source.SourceElementDetail;
import org.eclipse.statet.docmlet.wikitext.core.source.doc.WikitextPartitionNodeType;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNode;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeScan;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeScanner;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeType;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitioner;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.core.source.SourceContent;

@NonNullByDefault
public class WikitextPartitionNodeScanner
extends DocumentBuilder
implements TreePartitionNodeScanner {
    private WikitextMarkupLanguage markupLanguage;
    private final int markupLanguageMode;
    private TreePartitionNodeScan scan;
    private TreePartitionNode node;
    private int startOffset;
    private int endOffset;
    private WikitextLocator locator2;
    private int ignoreCounter;
    private final ArrayList<Attributes> attributeStack = new ArrayList();

    public WikitextPartitionNodeScanner(WikitextMarkupLanguage markupLanguage, int markupLanguageMode) {
        this.markupLanguageMode = markupLanguageMode;
        this.setMarkupLanguage(markupLanguage);
    }

    public WikitextPartitionNodeScanner(WikitextMarkupLanguage markupLanguage) {
        this(markupLanguage, 0);
    }

    public WikitextMarkupLanguage getMarkupLanguage() {
        return this.markupLanguage;
    }

    public void setMarkupLanguage(WikitextMarkupLanguage markupLanguage) {
        if (this.markupLanguage != null && this.markupLanguage.getName() == markupLanguage.getName() && this.markupLanguage.getClass() == markupLanguage.getClass()) {
            this.markupLanguage.setMarkupConfig(markupLanguage.getMarkupConfig());
            if (this.markupLanguage.equals(markupLanguage)) {
                return;
            }
        }
        this.markupLanguage = markupLanguage.clone("Doc/Partitioner", this.markupLanguageMode);
    }

    protected boolean isTemplateMode() {
        return (this.markupLanguageMode & 0x10) != 0;
    }

    public void setLocator(Locator locator) {
        super.setLocator(locator);
        this.locator2 = (WikitextLocator)locator;
    }

    public WikitextPartitionNodeType getDefaultRootType() {
        return WikitextPartitionNodeType.DEFAULT_ROOT;
    }

    /*
     * Unable to fully structure code
     */
    public void checkRestartState(TreePartitionNodeScan.State state, IDocument document, TreePartitioner partitioner) throws BadLocationException {
        rootType = this.getDefaultRootType();
        node = state.node;
        parent = node.getParent();
        if (parent != null) ** GOTO lbl8
        return;
lbl-1000:
        // 1 sources

        {
            node = parent;
            parent = node.getParent();
lbl8:
            // 2 sources

            ** while (parent.getType() != rootType)
        }
lbl9:
        // 1 sources

        nodeIdx = parent.indexOfChild(node);
        do {
            line = document.getLineOfOffset(node.getStartOffset());
            offset = document.getLineOffset(line);
        } while (nodeIdx > 0 && offset < (node = parent.getChild(--nodeIdx)).getEndOffset());
        if (offset == state.offset) {
            return;
        }
        state.offset = offset;
        state.node = partitioner.getTreeNode(offset, true);
    }

    public void execute(TreePartitionNodeScan scan) throws TreePartitionNodeScan.BreakException {
        this.scan = scan;
        this.node = null;
        this.setRange(scan.getStartOffset(), scan.getEndOffset());
        this.init();
        assert (this.node != null);
        this.process();
    }

    protected TreePartitionNodeScan getScan() {
        return this.scan;
    }

    protected void setRange(int startOffset, int endOffset) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    protected void init() {
        TreePartitionNode beginNode = this.getScan().getBeginNode();
        if (beginNode.getType() instanceof WikitextPartitionNodeType) {
            this.node = beginNode;
        } else {
            this.node = beginNode;
            this.addNode((TreePartitionNodeType)this.getDefaultRootType(), this.getScan().getStartOffset());
        }
    }

    protected final int getStartOffset() {
        return this.startOffset;
    }

    protected final void initNode(TreePartitionNode node) {
        if (ObjectUtils.isNonNull((Object)this.node)) {
            throw new IllegalStateException();
        }
        this.node = node;
    }

    protected final void addNode(TreePartitionNodeType type, int offset) {
        this.node = this.scan.add(type, this.node, offset, 0);
    }

    protected final TreePartitionNode getNode() {
        return this.node;
    }

    protected final void exitNode(int offset, int flags) {
        this.scan.expand(this.node, offset, flags, true);
        this.node = this.node.getParent();
    }

    protected final void exitNode() {
        this.node = this.node.getParent();
    }

    private void process() {
        try {
            try {
                WikitextPartitionNodeScanner builder = this;
                MarkupParser2 markupParser = new MarkupParser2(this.markupLanguage, builder);
                this.configure(markupParser);
                SourceContent content = new SourceContent(0L, this.scan.getDocument().get(this.startOffset, this.endOffset - this.startOffset), this.startOffset);
                markupParser.parse(content, false);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.attributeStack.clear();
        }
    }

    protected void configure(MarkupParser2 markupParser) {
        markupParser.disable(256);
        markupParser.enable(4096);
        markupParser.disable(112);
    }

    protected final int getEventBeginOffset() {
        return this.startOffset + this.locator2.getBeginOffset();
    }

    protected final int getEventEndOffset() {
        return this.startOffset + this.locator2.getEndOffset();
    }

    protected final int getEventFlags(Attributes attributes) {
        if (attributes instanceof SourceElementDetail) {
            return ((SourceElementDetail)attributes).getSourceElementDetail() & 0x100;
        }
        return 0;
    }

    public void beginDocument() {
    }

    public void endDocument() {
    }

    public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        if (this.ignoreCounter > 0 || this.ignore(type)) {
            ++this.ignoreCounter;
            return;
        }
        this.addNode((TreePartitionNodeType)WikitextPartitionNodeType.BLOCK_TYPES.get(type), this.getEventBeginOffset());
        this.attributeStack.add(attributes);
    }

    private boolean ignore(DocumentBuilder.BlockType type) {
        switch (type) {
            case LIST_ITEM: 
            case TABLE_ROW: 
            case TABLE_CELL_HEADER: 
            case TABLE_CELL_NORMAL: 
            case DEFINITION_ITEM: {
                return true;
            }
        }
        return this.node != null && this.node.getType() instanceof WikitextPartitionNodeType && ((WikitextPartitionNodeType)this.node.getType()).getBlockType() == DocumentBuilder.BlockType.QUOTE;
    }

    public void endBlock() {
        if (this.ignoreCounter > 0) {
            --this.ignoreCounter;
            return;
        }
        Attributes attributes = this.attributeStack.removeLast();
        this.exitNode(this.getEventEndOffset(), this.getEventFlags(attributes));
    }

    public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        this.scan.expand(this.node, this.getEventBeginOffset(), 0, false);
    }

    public void endSpan() {
        this.scan.expand(this.node, this.getEventEndOffset(), 0, false);
    }

    public void beginHeading(int level, Attributes attributes) {
        this.addNode((TreePartitionNodeType)WikitextPartitionNodeType.getHeadingType(level), this.getEventBeginOffset());
        this.attributeStack.add(attributes);
    }

    public void endHeading() {
        Attributes attributes = this.attributeStack.removeLast();
        this.exitNode(this.getEventEndOffset(), this.getEventFlags(attributes));
    }

    public void characters(String text) {
    }

    public void charactersUnescaped(String literal) {
    }

    public void entityReference(String entity) {
    }

    public void image(Attributes attributes, String url) {
    }

    public void link(Attributes attributes, String hrefOrHashName, String text) {
    }

    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
    }

    public void acronym(String text, String definition) {
    }

    public void lineBreak() {
    }
}

