/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.dsl.core.model;

import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.text.Position;
import org.eclipse.statet.dsl.core.model.DslElementName;
import org.eclipse.statet.dsl.core.source.ast.DslAstNode;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;

@NonNullByDefault
public abstract class DslLabelAccess
extends DslElementName {
    public static final Comparator<DslLabelAccess> NAME_POSITION_COMPARATOR = new Comparator<DslLabelAccess>(){

        @Override
        public int compare(DslLabelAccess o1, DslLabelAccess o2) {
            return o1.getNameNode().getStartOffset() - o2.getNameNode().getStartOffset();
        }
    };

    public static Position getTextPosition(DslAstNode node) {
        return new Position(node.getStartOffset(), node.getLength());
    }

    public static TextRegion getTextRegion(DslAstNode node) {
        return new BasicTextRegion((TextRegion)node);
    }

    protected DslLabelAccess() {
    }

    public abstract DslAstNode getNode();

    public abstract DslAstNode getNameNode();

    public abstract List<? extends DslLabelAccess> getAllInUnit();

    public abstract boolean isWriteAccess();
}

