/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.debug.core.sourcelookup;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.CompositeSourceContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.r.debug.core.sourcelookup.Messages;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.debug.core.sourcelookup.RLibrarySourceContainer;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;
import org.eclipse.statet.rj.renv.core.RLibGroup;
import org.eclipse.statet.rj.renv.core.RLibLocation;

public class REnvLibraryPathSourceContainer
extends CompositeSourceContainer {
    public static final String TYPE_ID = "org.eclipse.statet.r.debugSourceContainers.REnvLibraryPathType";
    private final REnv rEnv;

    public REnvLibraryPathSourceContainer(REnv rEnv) {
        if (rEnv == null) {
            throw new NullPointerException("rEnv");
        }
        this.rEnv = rEnv;
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    public String getName() {
        return NLS.bind((String)Messages.REnvLibraryPathSourceContainer_name, (Object)this.rEnv.getName());
    }

    public REnv getREnv() {
        return this.rEnv;
    }

    protected ISourceContainer[] createSourceContainers() throws CoreException {
        ArrayList<RLibrarySourceContainer> list = new ArrayList<RLibrarySourceContainer>();
        REnvConfiguration rEnvConfig = (REnvConfiguration)this.rEnv.get(REnvConfiguration.class);
        if (rEnvConfig == null) {
            this.abort(Messages.REnvLibraryPathSourceContainer_error_REnvNotAvailable_message, null);
        }
        ImList libraryGroups = rEnvConfig.getRLibGroups();
        for (RLibGroup group : libraryGroups) {
            List libraries = group.getLibLocations();
            for (RLibLocation lib : libraries) {
                Path path = lib.getDirectoryPath();
                if (path == null) continue;
                RLibrarySourceContainer container = new RLibrarySourceContainer(path.toString(), path);
                container.init(this.getDirector());
                list.add(container);
            }
        }
        return list.toArray(new ISourceContainer[list.size()]);
    }

    public int hashCode() {
        return this.rEnv.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return obj instanceof REnvLibraryPathSourceContainer && this.rEnv.equals(obj);
    }
}

