/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import java.util.function.Consumer;
import org.eclipse.statet.internal.r.debug.core.model.BasicRElementVariable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.debug.core.RVariable;

@NonNullByDefault
public class RElementVariableCompactStore {
    private final @Nullable BasicRElementVariable[] array;

    public RElementVariableCompactStore(int length) {
        this.array = new BasicRElementVariable[length];
    }

    public void set(int idx, BasicRElementVariable value) {
        this.array[idx] = value;
    }

    public @Nullable BasicRElementVariable get(int idx) {
        return this.array[idx];
    }

    public @Nullable BasicRElementVariable clear(int idx) {
        BasicRElementVariable value = this.array[idx];
        this.array[idx] = null;
        return value;
    }

    public void forEachSet(Consumer<BasicRElementVariable> action) {
        int idx = 0;
        while (idx < this.array.length) {
            BasicRElementVariable value = this.array[idx];
            if (value != null) {
                action.accept(value);
            }
            ++idx;
        }
    }

    public void toArray(@Nullable RVariable[] to, int idx) {
        System.arraycopy(this.array, 0, to, idx, this.array.length);
    }
}

