/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.breakpoints;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.internal.r.debug.core.breakpoints.GenericLineBreakpoint;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class LineBreakpointImpl
extends GenericLineBreakpoint {
    public static final String R_LINE_BREAKPOINT_MARKER_TYPE = "org.eclipse.statet.r.resourceMarkers.RLineBreakpoint";

    public LineBreakpointImpl(final IResource resource, int lineNumber, int charStart, int charEnd, int elementType, String elementId, String elementLabel, String subLabel, final boolean temporary) throws CoreException {
        final HashMap<String, Object> attributes = new HashMap<String, Object>();
        this.addStandardLineBreakpointAttributes(attributes, true, lineNumber, charStart, charEnd, elementType, elementId, elementLabel, subLabel);
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                LineBreakpointImpl.this.setMarker(resource.createMarker(LineBreakpointImpl.R_LINE_BREAKPOINT_MARKER_TYPE, attributes));
                LineBreakpointImpl.this.register(!temporary);
                if (temporary) {
                    LineBreakpointImpl.this.setPersisted(false);
                }
            }
        };
        this.run(ResourcesPlugin.getWorkspace().getRuleFactory().markerRule(resource), wr);
    }

    public LineBreakpointImpl() {
    }

    @Override
    public String getBreakpointType() {
        return "org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint";
    }
}

