/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.eclient.graphics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.statet.ecommons.commands.core.BasicHandlerCollection;
import org.eclipse.statet.ecommons.commands.core.HandlerCollection;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.internal.rj.eclient.graphics.RGraphicsPlugin;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.rj.eclient.graphics.ERGraphic;
import org.eclipse.statet.rj.eclient.graphics.RGraphicComposite;
import org.eclipse.statet.rj.eclient.graphics.util.AbstractLocalLocator;
import org.eclipse.statet.rj.ts.core.AbstractRToolRunnable;
import org.eclipse.statet.rj.ts.core.RToolService;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public class RGraphicCompositeActionSet
implements ERGraphic.ListenerLocatorExtension {
    public static final String POSITION_STATUSLINE_ITEM_ID = "position";
    public static final String CONTEXT_MENU_GROUP_ID = "context";
    public static final String SIZE_MENU_GROUP_ID = "size";
    private static final String LOCATOR_DONE_COMMAND_ID = ".locator.done";
    private static final String LOCATOR_CANCEL_COMMAND_ID = ".locator.cancel";
    private static final String RESIZE_FIT_COMMAND_ID = ".resize.fit";
    private final List<IActionBars> actionBars = new ArrayList<IActionBars>(4);
    private ERGraphic graphic;
    private final RGraphicComposite graphicComposite;
    private final Display display;
    private HandlerCollection handlerCollection;
    private final CopyOnWriteIdentityListSet<LocationListener> mouseLocationListeners = new CopyOnWriteIdentityListSet();
    private MouseLocationListener mouseListenerListener;
    private ConversionRunnable mouseLocationRunnable;

    public RGraphicCompositeActionSet(RGraphicComposite composite) {
        this.graphicComposite = composite;
        this.display = this.graphicComposite.getDisplay();
    }

    public void setGraphic(ERGraphic graphic) {
        if (this.graphic != null) {
            this.graphic.removeListener(this);
            if (this.mouseLocationRunnable != null) {
                this.mouseLocationRunnable.cancel();
                this.mouseLocationRunnable = null;
            }
        }
        this.graphic = graphic;
        if (this.graphic != null) {
            this.graphic.addListener(this);
        }
        this.update();
    }

    public void initActions(IServiceLocator serviceLocator) {
        this.handlerCollection = new BasicHandlerCollection();
        this.handlerCollection.add(LOCATOR_DONE_COMMAND_ID, (IHandler2)new StopLocatorHandler("done"));
        this.handlerCollection.add(LOCATOR_CANCEL_COMMAND_ID, (IHandler2)new StopLocatorHandler("cancel"));
        this.handlerCollection.add(RESIZE_FIT_COMMAND_ID, (IHandler2)new ResizeFitRHandler());
    }

    public void contributeToActionsBars(IServiceLocator serviceLocator, IActionBars actionBars) {
        this.actionBars.add(actionBars);
        IToolBarManager toolBar = actionBars.getToolBarManager();
        if (toolBar.find(CONTEXT_MENU_GROUP_ID) == null) {
            toolBar.insertBefore("additions", (IContributionItem)new Separator(CONTEXT_MENU_GROUP_ID));
        }
        if (toolBar.find(SIZE_MENU_GROUP_ID) == null) {
            toolBar.insertBefore("additions", (IContributionItem)new Separator(SIZE_MENU_GROUP_ID));
        }
        ImageRegistry rGraphicsImageRegistry = RGraphicsPlugin.getInstance().getImageRegistry();
        toolBar.appendToGroup(CONTEXT_MENU_GROUP_ID, (IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "NO_COMMAND", null, rGraphicsImageRegistry.getDescriptor("org.eclipse.statet.rj.eclient.graphics/images/loctool/locator-done"), null, null, "Stop Locator", null, null, 8, null, true), this.handlerCollection.get(LOCATOR_DONE_COMMAND_ID)));
        toolBar.appendToGroup(CONTEXT_MENU_GROUP_ID, (IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "NO_COMMAND", null, rGraphicsImageRegistry.getDescriptor("org.eclipse.statet.rj.eclient.graphics/images/loctool/locator-cancel"), null, null, "Cancel Locator", null, null, 8, null, true), this.handlerCollection.get(LOCATOR_CANCEL_COMMAND_ID)));
    }

    protected void addTestLocator(IServiceLocator serviceLocator, IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        AbstractHandler handler = new AbstractHandler(){

            public void setEnabled(Object evaluationContext) {
                this.setBaseEnabled(RGraphicCompositeActionSet.this.graphic != null && !RGraphicCompositeActionSet.this.graphic.isLocatorStarted());
            }

            public Object execute(ExecutionEvent event) throws ExecutionException {
                if (RGraphicCompositeActionSet.this.graphic == null || RGraphicCompositeActionSet.this.graphic.isLocatorStarted()) {
                    return null;
                }
                AbstractLocalLocator locator = new AbstractLocalLocator(RGraphicCompositeActionSet.this.graphic){

                    @Override
                    protected void finished(List<double[]> graphic, List<double[]> user) {
                        final StringBuilder sb = new StringBuilder();
                        int i = 0;
                        while (i < user.size()) {
                            sb.append(Arrays.toString(user.get(i))).append("\n");
                            ++i;
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openInformation(null, (String)"Locator Result", (String)sb.toString());
                            }
                        });
                    }

                    @Override
                    protected void canceled() {
                    }
                };
                locator.start();
                return null;
            }
        };
        this.handlerCollection.add(".locator.startTest", (IHandler2)handler);
        toolBar.appendToGroup(CONTEXT_MENU_GROUP_ID, (IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "NO_COMMAND", null, SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/images/loctool/sort-score"), null, null, "Test Locator", null, null, 8, null, false), (IHandler2)handler));
    }

    protected void addSizeActions(IServiceLocator serviceLocator, IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        ImageRegistry rGraphicsImageRegistry = RGraphicsPlugin.getInstance().getImageRegistry();
        toolBar.appendToGroup(SIZE_MENU_GROUP_ID, (IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "NO_COMMAND", null, rGraphicsImageRegistry.getDescriptor("org.eclipse.statet.rj.eclient.graphics/images/loctool/resize-fit-r"), null, null, "Resize Fit in R", null, null, 8, null, false), this.handlerCollection.get(RESIZE_FIT_COMMAND_ID)));
        this.update();
    }

    protected void update() {
        if (this.actionBars.isEmpty()) {
            return;
        }
        this.handlerCollection.update(null);
        for (IActionBars actionBars : this.actionBars) {
            actionBars.getToolBarManager().update(true);
        }
    }

    public void activated() {
    }

    public void deactivated() {
    }

    public void drawingStarted() {
    }

    public void drawingStopped() {
    }

    @Override
    public void locatorStarted() {
        this.update();
    }

    @Override
    public void locatorStopped() {
        this.update();
    }

    public void addMouseClickLocationListener(LocationListener listener) {
        this.mouseLocationListeners.add((Object)listener);
        if (this.mouseListenerListener == null) {
            this.mouseListenerListener = new MouseLocationListener();
            Control widget = this.graphicComposite.getGraphicWidget();
            widget.addListener(3, (Listener)this.mouseListenerListener);
        }
    }

    public void removeMouseLocationListener(LocationListener listener) {
        this.mouseLocationListeners.remove((Object)listener);
    }

    private void notifyMouseLocationListeners(double[] xy) {
        if (xy != null) {
            for (LocationListener listener : this.mouseLocationListeners) {
                listener.located(xy[0], xy[1]);
            }
        } else {
            for (LocationListener listener : this.mouseLocationListeners) {
                listener.loading();
            }
        }
    }

    public void dispose(IActionBars actionBars) {
        this.actionBars.remove(actionBars);
    }

    public void dispose() {
        this.setGraphic(null);
    }

    private static abstract class ConversionRunnable
    extends AbstractRToolRunnable
    implements SystemRunnable {
        private final ERGraphic graphic;
        private boolean scheduled;
        private double[] todoSource;
        private double[] convertedSource;
        private double[] convertedTarget;

        public ConversionRunnable(ERGraphic graphic) {
            super("r/rjgd/position", "Converting graphic coordinates");
            this.graphic = graphic;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean schedule(double[] source) {
            ConversionRunnable conversionRunnable = this;
            synchronized (conversionRunnable) {
                block6: {
                    block5: {
                        this.todoSource = source;
                        if (!this.scheduled) break block5;
                        return true;
                    }
                    Status status = this.graphic.getRHandle().getQueue().addHot((ToolRunnable)this);
                    if (status.getSeverity() != 0) break block6;
                    this.scheduled = true;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            ConversionRunnable conversionRunnable = this;
            synchronized (conversionRunnable) {
                if (this.scheduled) {
                    this.scheduled = false;
                    this.todoSource = null;
                    this.graphic.getRHandle().getQueue().removeHot((ToolRunnable)this);
                }
            }
        }

        public boolean canRunIn(Tool tool) {
            return tool == this.graphic.getRHandle() && super.canRunIn(tool);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean changed(int event, Tool tool) {
            switch (event) {
                case 289: {
                    return false;
                }
                case 288: 
                case 290: 
                case 340: 
                case 344: {
                    ConversionRunnable conversionRunnable = this;
                    synchronized (conversionRunnable) {
                        this.scheduled = false;
                        break;
                    }
                }
                case 336: {
                    this.converted(this.graphic, this.convertedSource, this.convertedTarget);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void run(RToolService service, ProgressMonitor m) throws StatusException {
            double[] source = null;
            double[] target = null;
            while (true) {
                ConversionRunnable conversionRunnable = this;
                synchronized (conversionRunnable) {
                    this.convertedSource = source;
                    this.convertedTarget = target;
                    source = this.todoSource;
                    if (source == null) {
                        this.scheduled = false;
                        return;
                    }
                    this.todoSource = null;
                }
                target = this.graphic.convertGraphic2User(source, m);
            }
        }

        protected abstract void converted(ERGraphic var1, double[] var2, double[] var3);
    }

    public static interface LocationListener {
        public void loading();

        public void located(double var1, double var3);
    }

    private class MouseLocationListener
    implements Listener {
        private double[] currentGraphic;
        private double[] currentTarget;

        private MouseLocationListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 3: {
                    if (event.button != 1) break;
                    this.currentGraphic = new double[]{RGraphicCompositeActionSet.this.graphicComposite.convertWidget2GraphicX(event.x), RGraphicCompositeActionSet.this.graphicComposite.convertWidget2GraphicY(event.y)};
                    final double[] request = this.currentGraphic;
                    this.currentTarget = null;
                    event.display.timerExec(1000, new Runnable(){

                        @Override
                        public void run() {
                            if (MouseLocationListener.this.currentTarget == null && MouseLocationListener.this.currentGraphic == request && !((MouseLocationListener)MouseLocationListener.this).RGraphicCompositeActionSet.this.graphicComposite.isDisposed()) {
                                RGraphicCompositeActionSet.this.notifyMouseLocationListeners(null);
                            }
                        }
                    });
                    if (RGraphicCompositeActionSet.this.mouseLocationRunnable == null) {
                        RGraphicCompositeActionSet.this.mouseLocationRunnable = new ConversionRunnable(RGraphicCompositeActionSet.this.graphic){

                            @Override
                            protected void converted(final ERGraphic graphic, final double[] source, final double[] target) {
                                if (((MouseLocationListener)MouseLocationListener.this).RGraphicCompositeActionSet.this.graphic == graphic) {
                                    ((MouseLocationListener)MouseLocationListener.this).RGraphicCompositeActionSet.this.display.asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (((MouseLocationListener)(this).MouseLocationListener.this).RGraphicCompositeActionSet.this.graphic == graphic && source != null && target != null && (this).MouseLocationListener.this.currentGraphic != null && source[0] == (this).MouseLocationListener.this.currentGraphic[0] && source[1] == (this).MouseLocationListener.this.currentGraphic[1]) {
                                                (this).MouseLocationListener.this.currentTarget = target;
                                                RGraphicCompositeActionSet.this.notifyMouseLocationListeners(target);
                                            }
                                        }
                                    });
                                }
                            }
                        };
                    }
                    RGraphicCompositeActionSet.this.mouseLocationRunnable.schedule(this.currentGraphic);
                }
            }
        }
    }

    private class ResizeFitRHandler
    extends AbstractHandler {
        public void setEnabled(Object evaluationContext) {
            this.setBaseEnabled(RGraphicCompositeActionSet.this.graphic != null);
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            if (RGraphicCompositeActionSet.this.graphic == null) {
                return null;
            }
            double[] size = RGraphicCompositeActionSet.this.graphicComposite.getGraphicFitSize();
            Status status = RGraphicCompositeActionSet.this.graphic.resize(size[0], size[1]);
            if (status == null || status.getSeverity() != 0) {
                Display.getCurrent().beep();
            }
            return null;
        }
    }

    protected class StopLocatorHandler
    extends AbstractHandler {
        private final String type;

        public StopLocatorHandler(String type) {
            this.type = type;
        }

        public void setEnabled(Object evaluationContext) {
            this.setBaseEnabled(RGraphicCompositeActionSet.this.graphic != null && RGraphicCompositeActionSet.this.graphic.isLocatorStarted() && RGraphicCompositeActionSet.this.graphic.getLocatorStopTypes().contains(this.type));
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            if (RGraphicCompositeActionSet.this.graphic == null) {
                return null;
            }
            RGraphicCompositeActionSet.this.graphic.stopLocator(this.type);
            return null;
        }
    }
}

