/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.snakeyaml.scanner;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public final class CharConstants {
    private static final String ALPHA_S = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-_";
    private static final String LINEBR_S = "\n";
    private static final String FULL_LINEBR_S = "\r\n";
    private static final String NULL_OR_LINEBR_S = "\u0000\r\n";
    private static final String NULL_BL_T_LINEBR_S = " \t\u0000\r\n";
    public static final CharConstants NULL_BL_T_LINEBR = new CharConstants(" \t\u0000\r\n");
    public static final CharConstants ALPHA = new CharConstants("abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-_");
    private static final int ASCII_SIZE = 128;
    boolean[] contains = new boolean[128];
    private static final Map<Character, Character> ESCAPE_REPLACEMENTS;
    private static final Map<Character, Character> ESCAPES;

    static {
        HashMap<Character, Character> escapeReplacements = new HashMap<Character, Character>();
        HashMap escapes = new HashMap();
        escapeReplacements.put(Character.valueOf('0'), Character.valueOf('\u0000'));
        escapeReplacements.put(Character.valueOf('a'), Character.valueOf('\u0007'));
        escapeReplacements.put(Character.valueOf('b'), Character.valueOf('\b'));
        escapeReplacements.put(Character.valueOf('t'), Character.valueOf('\t'));
        escapeReplacements.put(Character.valueOf('n'), Character.valueOf('\n'));
        escapeReplacements.put(Character.valueOf('v'), Character.valueOf('\u000b'));
        escapeReplacements.put(Character.valueOf('f'), Character.valueOf('\f'));
        escapeReplacements.put(Character.valueOf('r'), Character.valueOf('\r'));
        escapeReplacements.put(Character.valueOf('e'), Character.valueOf('\u001b'));
        escapeReplacements.put(Character.valueOf(' '), Character.valueOf(' '));
        escapeReplacements.put(Character.valueOf('\t'), Character.valueOf('\t'));
        escapeReplacements.put(Character.valueOf('\"'), Character.valueOf('\"'));
        escapeReplacements.put(Character.valueOf('/'), Character.valueOf('/'));
        escapeReplacements.put(Character.valueOf('\\'), Character.valueOf('\\'));
        escapeReplacements.put(Character.valueOf('N'), Character.valueOf('\u0085'));
        escapeReplacements.put(Character.valueOf('_'), Character.valueOf('\u00a0'));
        escapeReplacements.put(Character.valueOf('L'), Character.valueOf('\u2028'));
        escapeReplacements.put(Character.valueOf('P'), Character.valueOf('\u2029'));
        escapeReplacements.entrySet().stream().filter(entry -> ((Character)entry.getKey()).charValue() != ' ' && ((Character)entry.getKey()).charValue() != '/').forEach(entry -> {
            Character c = escapes.put((Character)entry.getValue(), (Character)entry.getKey());
        });
        ESCAPE_REPLACEMENTS = Collections.unmodifiableMap(escapeReplacements);
        ESCAPES = Collections.unmodifiableMap(escapes);
    }

    private CharConstants(String content) {
        Arrays.fill(this.contains, false);
        int i = 0;
        while (i < content.length()) {
            int c = content.codePointAt(i);
            this.contains[c] = true;
            ++i;
        }
    }

    public boolean has(int c) {
        return c < 128 && this.contains[c];
    }

    public boolean hasNo(int c) {
        return !this.has(c);
    }

    public boolean has(int c, String additional) {
        return this.has(c) || additional.indexOf(c) != -1;
    }

    public boolean hasNo(int c, String additional) {
        return !this.has(c, additional);
    }

    public static boolean isEol(int ch) {
        switch (ch) {
            case 0: 
            case 10: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    public static boolean isWhiteSpace(int ch) {
        switch (ch) {
            case 9: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public static boolean isWhiteSpaceOrEol(int ch) {
        switch (ch) {
            case 0: 
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public static boolean isWhiteSpaceOrEolOr(int ch, char alt1, char alt2) {
        switch (ch) {
            case 0: 
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return ch == alt1 || ch == alt2;
    }

    public static boolean isHexDigit(int ch) {
        switch (ch) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return true;
            }
        }
        return false;
    }

    public static boolean isFlowCollectionControl(int c) {
        switch (c) {
            case 44: 
            case 91: 
            case 93: 
            case 123: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    public static boolean isWhiteSpaceOrEolOrFlowCollectionControl(int c) {
        switch (c) {
            case 0: 
            case 9: 
            case 10: 
            case 13: 
            case 32: 
            case 44: 
            case 91: 
            case 93: 
            case 123: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    public static boolean isFlowCollectionEntryEndControl(int c) {
        switch (c) {
            case 44: 
            case 93: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIdentifierChar(int c) {
        switch (c) {
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                return true;
            }
        }
        return false;
    }

    public static boolean isUriChar(int c) {
        switch (c) {
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 126: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTagChar(int c) {
        switch (c) {
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 126: {
                return true;
            }
        }
        return false;
    }

    public static boolean isOr(int ch, char alt1, char alt2) {
        return ch == alt1 || ch == alt2;
    }

    public static boolean isOr(int ch, char alt1, char alt2, char alt3) {
        return ch == alt1 || ch == alt2 || ch == alt3;
    }

    public static @Nullable Character getEscapeReplacement(Character c) {
        return ESCAPE_REPLACEMENTS.get(c);
    }

    public static @Nullable Character getEscapeChar(Character c) {
        return ESCAPES.get(c);
    }

    public static int getEscapeCodeBytes(char c) {
        switch (c) {
            case 'x': {
                return 2;
            }
            case 'u': {
                return 4;
            }
            case 'U': {
                return 8;
            }
        }
        return -1;
    }
}

