/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rtm.ftable.core;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.statet.rtm.base.core.AbstractRCodeGenerator;
import org.eclipse.statet.rtm.ftable.FTable;
import org.eclipse.statet.rtm.ftable.FTablePackage;
import org.eclipse.statet.rtm.rtdata.types.RTypedExpr;

public class FTableRCodeGen
extends AbstractRCodeGenerator {
    private final String tableVar = "ft";

    public void generate(EObject root) {
        this.reset();
        if (root == null) {
            return;
        }
        if (root.eClass() != FTablePackage.Literals.FTABLE) {
            throw new IllegalArgumentException("root: " + root.eClass().getName());
        }
        this.appendNewLine();
        this.genRCode((FTable)root);
        AbstractRCodeGenerator.FunBuilder printFun = this.appendFun("openInEditor");
        printFun.append("elementName", "ft");
        printFun.close();
        this.appendNewLine();
    }

    public void genRCode(FTable table) {
        this.appendAssign("ft");
        AbstractRCodeGenerator.FunBuilder fun = this.appendFun("ftable");
        this.appendData(fun, table);
        this.appendVars(fun, "col.vars", (List<RTypedExpr>)table.getColVars());
        this.appendVars(fun, "row.vars", (List<RTypedExpr>)table.getRowVars());
        fun.close();
        this.appendNewLine();
    }

    private void appendData(AbstractRCodeGenerator.FunBuilder fun, FTable obj) {
        if (obj.getData() != null) {
            Object expr = obj.getData().getExpr();
            RTypedExpr dataFilter = obj.getDataFilter();
            if (dataFilter != null) {
                expr = (String)expr + dataFilter.getExpr();
            }
            fun.append("x", (String)expr);
        }
    }

    private void appendVars(AbstractRCodeGenerator.FunBuilder fun, String argName, List<RTypedExpr> exprs) {
        if (exprs.isEmpty()) {
            return;
        }
        fun.appendEmpty(argName);
        this.appendExprsC(exprs, QUOTE_PROCESSOR);
    }
}

