/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rtm.base.ui.editors;

import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.commands.core.HandlerCollection;
import org.eclipse.statet.ecommons.emf.ui.forms.EFEditor;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.internal.rtm.base.ui.actions.RunRTaskHandler;
import org.eclipse.statet.internal.rtm.base.ui.editors.RCodeGenEditorInput;
import org.eclipse.statet.internal.rtm.base.ui.editors.RTaskGenManager;
import org.eclipse.statet.ltk.core.input.SourceFragment;
import org.eclipse.statet.rtm.base.ui.IRtDescriptor;
import org.eclipse.statet.rtm.base.ui.RTaskSnippet;
import org.eclipse.statet.rtm.base.ui.RtModelUIPlugin;
import org.eclipse.statet.rtm.base.ui.editors.RCodePage;
import org.eclipse.statet.rtm.base.ui.editors.RtFormToolkit;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class RTaskEditor
extends EFEditor {
    public static final String MAIN_PAGE_ID = "Main";
    private final RTaskGenManager rCodeGenAdapter = new RTaskGenManager(this);

    public RTaskEditor(IRtDescriptor descriptor) {
        super(descriptor);
        this.getEditingDomain().getResourceSet().eAdapters().add((Object)this.rCodeGenAdapter);
    }

    @Override
    public IRtDescriptor getModelDescriptor() {
        return (IRtDescriptor)super.getModelDescriptor();
    }

    @Override
    protected RtFormToolkit createToolkit(Display display) {
        return new RtFormToolkit(RtModelUIPlugin.getInstance().getFormColors(display));
    }

    public void addPages() {
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty()) {
            try {
                this.addFormPages();
                RCodePage rCodePage = new RCodePage(this);
                this.addPage((IEditorPart)rCodePage, (IEditorInput)new RCodeGenEditorInput((SourceFragment)this.rCodeGenAdapter.getCodeFragment()));
            }
            catch (PartInitException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.rtm.base.ui", 0, "An error occured when creating the pages for the R task editor.", (Throwable)e));
            }
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (RTaskEditor.this.getPageCount() > 0) {
                        RTaskEditor.this.setActivePage(0);
                    }
                }
            });
        }
    }

    protected abstract void addFormPages() throws PartInitException;

    @Override
    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
    }

    @Override
    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType == RTaskSnippet.class) {
            return (T)this.rCodeGenAdapter.getRTaskSnippet();
        }
        return super.getAdapter(adapterType);
    }

    @Override
    protected void operationFailed(String operation, Exception e) {
        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.rtm.base.ui", 0, NLS.bind((String)"An error occurred when ''{0}'' in R task editor.", (Object)operation), (Throwable)e));
    }

    @Override
    protected void createActions(IServiceLocator locator, HandlerCollection handlers) {
        super.createActions(locator, handlers);
        IContextService contextService = (IContextService)locator.getService(IContextService.class);
        contextService.activateContext("org.eclipse.statet.rtm.contexts.RTaskEditor");
        IHandlerService handlerService = (IHandlerService)locator.getService(IHandlerService.class);
        RunRTaskHandler handler = new RunRTaskHandler((IWorkbenchPart)this);
        handlers.add("org.eclipse.statet.rtm.commands.RunRTask", (IHandler2)handler);
        handlerService.activateHandler("org.eclipse.statet.rtm.commands.RunRTask", (IHandler)handler);
    }

    @Override
    protected void contributeToPages(IToolBarManager manager) {
        super.contributeToPages(manager);
        IHandler2 handler = this.handlers.get("org.eclipse.statet.rtm.commands.RunRTask");
        manager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)this.getSite(), null, "org.eclipse.statet.rtm.commands.RunRTask", 8), handler));
    }
}

