/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.services.util;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RReference;
import org.eclipse.statet.rj.services.FQRObject;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.services.RGraphicCreator;
import org.eclipse.statet.rj.services.RPlatform;
import org.eclipse.statet.rj.services.RService;

@NonNullByDefault
public class RServiceWrapper
implements RService {
    protected final RService service;

    public RServiceWrapper(RService service) {
        this.service = service;
    }

    @Override
    public RPlatform getPlatform() {
        return this.service.getPlatform();
    }

    @Override
    public void evalVoid(String expression, ProgressMonitor m) throws StatusException {
        this.service.evalVoid(expression, m);
    }

    @Override
    public void evalVoid(String expression, @Nullable RObject envir, ProgressMonitor m) throws StatusException {
        this.service.evalVoid(expression, envir, m);
    }

    @Override
    public RObject evalData(String expression, ProgressMonitor m) throws StatusException {
        return this.service.evalData(expression, m);
    }

    @Override
    public RObject evalData(String expression, @Nullable String factoryId, int options, int depth, ProgressMonitor m) throws StatusException {
        return this.service.evalData(expression, factoryId, options, depth, m);
    }

    @Override
    public RObject evalData(String expression, @Nullable RObject envir, @Nullable String factoryId, int options, int depth, ProgressMonitor m) throws StatusException {
        return this.service.evalData(expression, envir, factoryId, options, depth, m);
    }

    @Override
    public RObject evalData(RReference reference, ProgressMonitor m) throws StatusException {
        return this.service.evalData(reference, m);
    }

    @Override
    public RObject evalData(RReference reference, @Nullable String factoryId, int options, int depth, ProgressMonitor m) throws StatusException {
        return this.service.evalData(reference, factoryId, options, depth, m);
    }

    @Override
    public @Nullable FQRObject<?> findData(String symbol, @Nullable RObject env, boolean inherits, @Nullable String factoryId, int options, int depth, ProgressMonitor m) throws StatusException {
        return this.service.findData(symbol, env, inherits, factoryId, options, depth, m);
    }

    @Override
    public void assignData(String target, RObject data, ProgressMonitor m) throws StatusException {
        this.service.assignData(target, data, m);
    }

    @Override
    public void uploadFile(InputStream in, long length, String fileName, int options, ProgressMonitor m) throws StatusException {
        this.service.uploadFile(in, length, fileName, options, m);
    }

    @Override
    public void downloadFile(OutputStream out, String fileName, int options, ProgressMonitor m) throws StatusException {
        this.service.downloadFile(out, fileName, options, m);
    }

    @Override
    public byte[] downloadFile(String fileName, int options, ProgressMonitor m) throws StatusException {
        return this.service.downloadFile(fileName, options, m);
    }

    @Override
    public FunctionCall createFunctionCall(String name) throws StatusException {
        return this.service.createFunctionCall(name);
    }

    @Override
    public RGraphicCreator createRGraphicCreator(int options) throws StatusException {
        return this.service.createRGraphicCreator(options);
    }
}

