/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.srvext;

import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.util.Locale;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.RjInitFailedException;
import org.eclipse.statet.rj.server.ServerLogin;
import org.eclipse.statet.rj.server.srvext.Client;

@NonNullByDefault
public abstract class ServerAuthMethod {
    private static final Logger LOGGER = Logger.getLogger("org.eclipse.statet.rj.server.auth");
    private final String logPrefix;
    private final String id;
    private final Random randomGenerator = new SecureRandom();
    private final boolean usePubkeyExchange;
    private @Nullable KeyPairGenerator keyPairGenerator;
    private @Nullable String pendingLoginClient;
    private long pendingLoginId;
    private @Nullable KeyPair pendingLoginKeyPair;
    private @Nullable String expliciteClient;
    private boolean isInitialized;

    protected static void copyAnswer(ImList<Callback> from, Callback[] to) throws UnsupportedCallbackException {
        if (from.size() != to.length) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < from.size()) {
            Callback source = (Callback)from.get(i);
            if (!(source instanceof TextOutputCallback)) {
                if (source instanceof NameCallback) {
                    ((NameCallback)to[i]).setName(((NameCallback)source).getName());
                } else if (source instanceof PasswordCallback) {
                    ((PasswordCallback)to[i]).setPassword(((PasswordCallback)source).getPassword());
                    ((PasswordCallback)source).clearPassword();
                } else if (source instanceof TextInputCallback) {
                    ((TextInputCallback)to[i]).setText(((TextInputCallback)source).getText());
                } else if (source instanceof ChoiceCallback) {
                    int[] selectedIndexes = ((ChoiceCallback)source).getSelectedIndexes();
                    if (((ChoiceCallback)source).allowMultipleSelections()) {
                        ((ChoiceCallback)to[i]).setSelectedIndexes(selectedIndexes);
                    } else if (selectedIndexes.length == 1) {
                        ((ChoiceCallback)to[i]).setSelectedIndex(selectedIndexes[0]);
                    }
                } else if (source instanceof ConfirmationCallback) {
                    ((ConfirmationCallback)to[i]).setSelectedIndex(((ConfirmationCallback)source).getSelectedIndex());
                } else if (source instanceof LanguageCallback) {
                    ((LanguageCallback)to[i]).setLocale(Locale.getDefault());
                } else {
                    throw new UnsupportedCallbackException(to[i]);
                }
            }
            ++i;
        }
    }

    protected ServerAuthMethod(String id, boolean usePubkeyExchange) {
        this.usePubkeyExchange = usePubkeyExchange;
        this.id = id;
        this.logPrefix = "[Auth:" + id + "]";
    }

    public void setExpliciteClient(String client) {
        this.expliciteClient = client;
    }

    private String getCallingClient() throws ServerNotActiveException {
        String expliciteClient = this.expliciteClient;
        if (expliciteClient != null) {
            return expliciteClient;
        }
        return RemoteServer.getClientHost();
    }

    public boolean isValid(Client client) {
        try {
            return this.getCallingClient().equals(client.clientId);
        }
        catch (ServerNotActiveException e) {
            return false;
        }
    }

    public final void init(@Nullable String arg) throws RjException {
        try {
            try {
                if (this.usePubkeyExchange) {
                    KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
                    keyPairGenerator.initialize(2048);
                    this.keyPairGenerator = keyPairGenerator;
                }
                this.doInit(arg);
                this.isInitialized = true;
            }
            catch (Exception e) {
                RjException rje = e instanceof RjException ? (RjException)e : new RjInitFailedException("An error occurred when initializing authentication method '" + this.id + "'.", e);
                throw rje;
            }
        }
        finally {
            System.gc();
        }
    }

    protected final Random getRandom() {
        return this.randomGenerator;
    }

    protected final void assertInitialized() {
        if (!this.isInitialized) {
            throw new IllegalStateException("not initialized");
        }
    }

    protected abstract void doInit(@Nullable String var1) throws RjException;

    public final ServerLogin createLogin() throws RjException {
        this.assertInitialized();
        try {
            long nextId;
            String client = this.getCallingClient();
            boolean same = client.equals(this.pendingLoginClient);
            this.pendingLoginClient = client;
            LOGGER.log(Level.INFO, "{0} creating new login ({1}).", new Object[]{this.logPrefix, client});
            while ((nextId = this.randomGenerator.nextLong()) == this.pendingLoginId) {
            }
            this.pendingLoginId = nextId;
            if (this.usePubkeyExchange && (this.pendingLoginKeyPair == null || !same)) {
                KeyPairGenerator keyPairGenerator = (KeyPairGenerator)ObjectUtils.nonNullAssert((Object)this.keyPairGenerator);
                this.pendingLoginKeyPair = ((KeyPairGenerator)ObjectUtils.nonNullAssert((Object)keyPairGenerator)).generateKeyPair();
            }
            return this.createNewLogin(this.doCreateLogin());
        }
        catch (Exception e) {
            RjException rje = e instanceof RjException ? (RjException)e : new RjException("An unexpected error occurred when preparing login process.", e);
            throw rje;
        }
    }

    protected abstract ImList<Callback> doCreateLogin() throws RjException;

    private ServerLogin createNewLogin(ImList<Callback> callbacks) {
        if (this.usePubkeyExchange) {
            KeyPair loginKeyPair = (KeyPair)ObjectUtils.nonNullAssert((Object)this.pendingLoginKeyPair);
            return new ServerLogin(this.pendingLoginId, loginKeyPair.getPublic(), callbacks);
        }
        return new ServerLogin(this.pendingLoginId, null, callbacks);
    }

    public final Client performLogin(ServerLogin login) throws RjException, LoginException {
        this.assertInitialized();
        String client = null;
        try {
            client = this.getCallingClient();
            if (login.getId() != this.pendingLoginId || !client.equals(this.pendingLoginClient)) {
                throw new FailedLoginException("Login process was interrupted by another client.");
            }
            if (this.usePubkeyExchange) {
                KeyPair loginKeyPair = (KeyPair)ObjectUtils.nonNullAssert((Object)this.pendingLoginKeyPair);
                login.readAnswer(loginKeyPair.getPrivate());
            } else {
                login.readAnswer(null);
            }
            this.pendingLoginKeyPair = null;
            String name = this.doPerformLogin(login.getCallbacks());
            LOGGER.log(Level.INFO, "{0} performing login completed successfull: {1} ({2}).", new Object[]{this.logPrefix, name, client});
            Client client2 = new Client(name, this.getCallingClient(), 0);
            return client2;
        }
        catch (LoginException e) {
            LogRecord log = new LogRecord(Level.INFO, "{0} performing login failed ({1}).");
            log.setParameters(new Object[]{this.logPrefix, client});
            log.setThrown(e);
            LOGGER.log(log);
            throw e;
        }
        catch (RjException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RjException("An unexpected error occurred when validating the login credential.", e);
        }
        finally {
            System.gc();
        }
    }

    protected abstract String doPerformLogin(ImList<Callback> var1) throws LoginException, RjException;
}

