/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.srv.engine;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.login.LoginException;
import org.eclipse.statet.jcommons.io.FileUtils;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rj.RjClosedException;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.server.DataCmdItem;
import org.eclipse.statet.rj.server.MainCmdC2SList;
import org.eclipse.statet.rj.server.MainCmdItem;
import org.eclipse.statet.rj.server.MainCmdS2CList;
import org.eclipse.statet.rj.server.RjsComConfig;
import org.eclipse.statet.rj.server.RjsComObject;
import org.eclipse.statet.rj.server.RjsException;
import org.eclipse.statet.rj.server.RjsStatus;
import org.eclipse.statet.rj.server.Server;
import org.eclipse.statet.rj.server.ServerInfo;
import org.eclipse.statet.rj.server.ServerLogin;
import org.eclipse.statet.rj.server.srv.RMIServerControl;
import org.eclipse.statet.rj.server.srv.engine.SrvEngine;
import org.eclipse.statet.rj.server.srv.engine.SrvEnginePluginExtension;
import org.eclipse.statet.rj.server.srvext.Client;
import org.eclipse.statet.rj.server.srvext.ServerAuthMethod;
import org.eclipse.statet.rj.server.srvext.ServerRuntimePlugin;
import org.eclipse.statet.rj.server.util.ServerUtils;

@NonNullByDefault
public class SrvEngineServer
implements Server,
RjsComConfig.PathResolver {
    private static final List<Remote> clients = new CopyOnWriteArrayList<Remote>();
    protected static final Logger LOGGER = Logger.getLogger("org.eclipse.statet.rj.server");
    protected final RMIServerControl control;
    protected SrvEngine srvEngine;
    private final String[] userTypes;
    private @Nullable String[] userNames;
    protected Path workingDirectory;
    protected long timestamp;
    protected ServerAuthMethod authMethod;
    protected final Client serverClient = new Client("rservi", "dummy", 1);
    private final MainCmdC2SList serverC2SList = new MainCmdC2SList();

    public static void addClient(Remote remote) {
        clients.add((Remote)ObjectUtils.nonNullAssert((Object)remote));
    }

    public static void removeClient(@Nullable Remote remote) {
        if (remote != null) {
            clients.remove(remote);
        }
    }

    public static boolean isValid(@Nullable Remote remote) {
        return remote != null && clients.contains(remote);
    }

    public SrvEngineServer(RMIServerControl control, ServerAuthMethod authMethod) {
        this.control = (RMIServerControl)ObjectUtils.nonNullAssert((Object)control);
        this.userTypes = this.createUserTypes();
        this.userNames = new String[this.userTypes.length];
        this.setUserName("owner", System.getProperty("user.name"));
        this.workingDirectory = FileUtils.getUserWorkingDirectory();
        this.authMethod = authMethod;
    }

    protected String[] createUserTypes() {
        return new String[]{"owner", "console"};
    }

    protected void setUserName(String type, @Nullable String name) {
        int i = 0;
        while (i < this.userTypes.length) {
            if (this.userTypes[i].equals(type)) {
                if (!Objects.equals(this.userNames[i], name)) {
                    @Nullable String[] newNames = new String[this.userTypes.length];
                    System.arraycopy(this.userNames, 0, newNames, 0, this.userTypes.length);
                    newNames[i] = name;
                    this.userNames = newNames;
                }
                return;
            }
            ++i;
        }
    }

    public boolean getConfigUnbindOnStartup() {
        return true;
    }

    public void setEngine(SrvEngine engine) {
        if (this.srvEngine != null) {
            throw new IllegalStateException();
        }
        this.srvEngine = engine;
    }

    public void start(ServerRuntimePlugin runtimePlugin) throws Exception {
        if (this.srvEngine instanceof SrvEnginePluginExtension) {
            ((SrvEnginePluginExtension)((Object)this.srvEngine)).addPlugin(runtimePlugin);
        }
    }

    @Override
    public int getState() throws RemoteException {
        return this.srvEngine.getState();
    }

    @Override
    public int[] getVersion() throws RemoteException {
        int[] internalVersion = this.srvEngine.getVersion();
        int[] version = new int[internalVersion.length];
        System.arraycopy(internalVersion, 0, version, 0, internalVersion.length);
        return version;
    }

    @Override
    public ServerInfo getInfo() throws RemoteException {
        return new ServerInfo(this.control.getName(), this.workingDirectory.toString(), this.timestamp, this.userTypes, this.userNames, this.srvEngine.getState());
    }

    protected ServerAuthMethod getAuthMethod(String command) {
        if (command.startsWith("console.")) {
            return this.authMethod;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final ServerLogin createLogin(String command) throws RemoteException {
        ServerAuthMethod authMethod = this.getAuthMethod(command);
        try {
            return authMethod.createLogin();
        }
        catch (RjException e) {
            String message = "Initializing login failed.";
            LOGGER.log(Level.SEVERE, "Initializing login failed.", e);
            throw new RemoteException("Initializing login failed.", e);
        }
    }

    protected Client connectClient(String command, ServerLogin login) throws RemoteException, LoginException {
        ServerAuthMethod authMethod = this.getAuthMethod(command);
        try {
            return authMethod.performLogin(login);
        }
        catch (RjException e) {
            String message = "Performing login failed.";
            LOGGER.log(Level.SEVERE, "Performing login failed.", e);
            throw new RemoteException("Performing login failed.", e);
        }
    }

    @Override
    public @Nullable Object execute(String command, Map<String, ? extends @NonNull Object> args, ServerLogin login) throws RemoteException, LoginException {
        block5: {
            try {
                if (!command.equals("console.start")) break block5;
                Client client = this.connectClient(command, login);
                Object r = this.srvEngine.start(client, args);
                Object startupTime = args.get("rj.session.startup.time");
                if (startupTime instanceof Long) {
                    this.timestamp = (Long)startupTime;
                }
                Object object = r;
                Client client2 = this.srvEngine.getCurrentClient();
                this.setUserName("console", client2 != null ? client2.getUsername() : null);
                return object;
            }
            catch (Throwable throwable) {
                Client client = this.srvEngine.getCurrentClient();
                this.setUserName("console", client != null ? client.getUsername() : null);
                throw throwable;
            }
        }
        if (command.equals("console.connect")) {
            Object r;
            Client client = this.connectClient(command, login);
            Object object = r = this.srvEngine.connect(client, args);
            Client client3 = this.srvEngine.getCurrentClient();
            this.setUserName("console", client3 != null ? client3.getUsername() : null);
            return object;
        }
        Client client = this.srvEngine.getCurrentClient();
        this.setUserName("console", client != null ? client.getUsername() : null);
        return null;
    }

    protected RObject runServerLoopCommand(DataCmdItem sendItem) throws RjException {
        RjsComObject sendCom = null;
        DataCmdItem answer = null;
        try {
            this.serverC2SList.setObjects(sendItem);
            sendCom = this.serverC2SList;
            block15: while (true) {
                RjsComObject receivedCom = this.runMainLoop(sendCom, null);
                sendCom = null;
                switch (receivedCom.getComType()) {
                    case 2: {
                        sendCom = RjsStatus.OK_STATUS;
                        continue block15;
                    }
                    case 1: {
                        RjsStatus status = (RjsStatus)receivedCom;
                        if ((status.getCode() & 0xFFFFFF00) == 0) {
                            switch (status.getCode()) {
                                case 17: 
                                case 25: 
                                case 26: {
                                    throw new RjExitException(status.getMessage());
                                }
                            }
                        }
                        switch (status.getSeverity()) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                break;
                            }
                            case 4: {
                                if (status.getCode() == 4) break block15;
                                throw new RjsException(status.getCode(), status.getMessage());
                            }
                        }
                        continue block15;
                    }
                    case 3: {
                        MainCmdS2CList list = (MainCmdS2CList)receivedCom;
                        MainCmdItem item = list.getItems();
                        while (item != null) {
                            if (item == sendItem) {
                                answer = sendItem;
                                continue block15;
                            }
                            this.processServerCmdItem(item);
                            item = item.next;
                        }
                    }
                    default: {
                        continue block15;
                    }
                }
                break;
            }
            this.serverC2SList.clear();
            if (answer == null || !answer.isOK()) {
                RjsStatus status = answer != null ? answer.getStatus() : ServerUtils.MISSING_ANSWER_STATUS;
                throw new RjException("R commands failed: " + status.getMessage() + ".");
            }
            return answer.getData();
        }
        catch (Exception e) {
            if (e instanceof RjException) {
                throw (RjException)e;
            }
            throw new RjException("An error when executing R command.", e);
        }
    }

    protected void processServerCmdItem(MainCmdItem item) {
        switch (item.getCmdType()) {
            case 1: {
                LOGGER.log(Level.INFO, "R-PROMPT: " + item.getDataText());
                break;
            }
            case 2: {
                LOGGER.log(Level.INFO, "R-OUT (" + item.getOp() + "): " + item.getDataText());
            }
        }
    }

    protected RjsComObject runMainLoop(RjsComObject com, Object caller) throws RemoteException {
        return this.srvEngine.runMainLoop(this.serverClient, com);
    }

    @Override
    public Path resolve(Remote ref, String pathString) throws RjException {
        if (!SrvEngineServer.isValid(ref)) {
            throw new RjException("Invalid access.");
        }
        Path path = Path.of(pathString, new String[0]);
        if (path.isAbsolute()) {
            return path;
        }
        try {
            Path rwd = Path.of(RDataUtils.checkSingleCharValue((RObject)this.runServerLoopCommand(new DataCmdItem(DataCmdItem.EVAL_EXPR_DATA, 0, -1, "getwd()", null, null, null, null))), new String[0]);
            if (rwd.isAbsolute()) {
                return rwd.resolve(path);
            }
            throw new UnexpectedRDataException("wd path is relative.");
        }
        catch (InvalidPathException | RjException | UnexpectedRDataException e) {
            throw new RjException("Resolving relative path failed.");
        }
    }

    protected static final class RjExitException
    extends RjClosedException {
        private static final long serialVersionUID = 1L;

        public RjExitException(String message) {
            super(message);
        }
    }
}

