/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RJIOExternalizable;
import org.eclipse.statet.rj.server.RjsComObject;

@NonNullByDefault
public final class RjsStatus
implements RjsComObject,
Externalizable,
RJIOExternalizable {
    public static final int OK = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 4;
    public static final int CANCEL = 8;
    public static final RjsStatus OK_STATUS = new RjsStatus(0, 0);
    public static final RjsStatus CANCEL_STATUS = new RjsStatus(8, 0);
    private int severity;
    private int code;
    private @Nullable String text;

    public RjsStatus(int severity, int code) {
        this.severity = severity;
        this.code = code;
        this.text = null;
    }

    public RjsStatus(int severity, int code, @Nullable String s) {
        this.severity = severity;
        this.code = code;
        this.text = s != null && s.length() > 0 ? s : null;
    }

    public RjsStatus() {
    }

    public RjsStatus(ObjectInput in) throws IOException {
        this.readExternal(in);
    }

    public RjsStatus(RJIO io) throws IOException {
        if (io.readBoolean()) {
            this.severity = io.readByte();
            this.code = io.readInt();
            this.text = io.readString();
        } else {
            this.severity = io.readByte();
            this.code = io.readInt();
            this.text = null;
        }
    }

    public void writeExternal(RJIO io) throws IOException {
        if (this.text != null) {
            io.writeBoolean(true);
            io.writeByte(this.severity);
            io.writeInt(this.code);
            io.writeString(this.text);
        } else {
            io.writeBoolean(false);
            io.writeByte(this.severity);
            io.writeInt(this.code);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        if (in.readBoolean()) {
            this.severity = in.readByte();
            this.code = in.readInt();
            this.text = in.readUTF();
        } else {
            this.severity = in.readByte();
            this.code = in.readInt();
            this.text = null;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.text != null) {
            out.writeBoolean(true);
            out.writeByte(this.severity);
            out.writeInt(this.code);
            out.writeUTF(this.text);
        } else {
            out.writeBoolean(false);
            out.writeByte(this.severity);
            out.writeInt(this.code);
        }
    }

    @Override
    public int getComType() {
        return 1;
    }

    public int getSeverity() {
        return this.severity;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.text != null ? this.text : "";
    }

    public int hashCode() {
        return this.severity + this.code;
    }

    public boolean equals(@Nullable Object obj) {
        RjsStatus other;
        return this == obj || obj instanceof RjsStatus && this.code == (other = (RjsStatus)obj).getCode() && this.severity == other.getSeverity() && Objects.equals(this.text, other.text);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("RjsStatus (severity=");
        switch (this.severity) {
            case 0: {
                sb.append("OK");
                break;
            }
            case 1: {
                sb.append("INFO");
                break;
            }
            case 2: {
                sb.append("WARNING");
                break;
            }
            case 4: {
                sb.append("ERROR");
                break;
            }
            case 8: {
                sb.append("CANCEL");
                break;
            }
            default: {
                sb.append(this.severity);
            }
        }
        sb.append(", code=0x");
        sb.append(Integer.toHexString(this.code));
        sb.append(")");
        if (this.text != null) {
            sb.append("\n<TEXT>\n");
            sb.append(this.text);
            sb.append("\n</TEXT>");
        } else {
            sb.append("\n<TEXT/>");
        }
        return sb.toString();
    }
}

