/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.rsetups;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.statet.rj.rsetups.RSetup;
import org.osgi.framework.Bundle;

public class RSetupUtil {
    public static final String EXTENSION_POINT_ID = "org.eclipse.statet.rj.RSetups";
    private static final String BUNDLE_ID = "org.eclipse.statet.rj.server";
    private static final ILog LOGGER = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.statet.rj.server"));
    private static final String SETUP_ELEMENT_NAME = "setup";
    private static final String BASE_ELEMENT_NAME = "base";
    private static final String LIBRARY_ELEMENT_NAME = "library";
    private static final String ID_ATTRIBUTE_NAME = "id";
    private static final String SETUP_ID_ATTRIBUTE_NAME = "setupId";
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private static final String INHERIT_BASE_ATTRIBUTE_NAME = "inheritBase";
    private static final String LOCATION_ATTRIBUTE_NAME = "location";
    private static final String GROUP_ATTRIBUTE_NAME = "group";

    public static List<RSetup> loadAvailableSetups(Map<String, String> filter) {
        HashSet<String> ids = new HashSet<String>();
        ArrayList<RSetup> setups = new ArrayList<RSetup>();
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int i = 0;
        while (i < configurationElements.length) {
            String id;
            if (configurationElements[i].getName().equals(SETUP_ELEMENT_NAME) && (id = configurationElements[i].getAttribute(ID_ATTRIBUTE_NAME)) != null && id.length() > 0 && !ids.contains(id)) {
                ids.add(id);
                RSetup setup = RSetupUtil.loadSetup(id, filter, configurationElements);
                if (setup != null) {
                    setups.add(setup);
                }
            }
            ++i;
        }
        return setups;
    }

    public static RSetup loadSetup(String id, Map<String, String> filter) {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        return RSetupUtil.loadSetup(id, filter, configurationElements);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static RSetup loadSetup(String id, Map<String, String> filter, IConfigurationElement[] configurationElements) {
        try {
            int i = 0;
            while (true) {
                if (i >= configurationElements.length) {
                    return null;
                }
                IConfigurationElement element = configurationElements[i];
                if (element.getName().equals(SETUP_ELEMENT_NAME) && id.equals(element.getAttribute(ID_ATTRIBUTE_NAME))) {
                    RSetup setup = new RSetup(id);
                    if (filter != null && filter.containsKey("$os$")) {
                        setup.setOS(filter.get("$os$"), filter.get("$arch$"));
                    } else {
                        setup.setOS(Platform.getOS(), Platform.getOSArch());
                    }
                    setup.setName(element.getAttribute(NAME_ATTRIBUTE_NAME));
                    RSetupUtil.loadSetupBase(id, filter, configurationElements, setup);
                    if (setup.getRHome() == null) {
                        RSetupUtil.log(2, "Incomplete R setup: Missing R home for setup '" + id + "', the setup is ignored.", element);
                        return null;
                    }
                    RSetupUtil.loadSetupLibraries(id, filter, configurationElements, setup);
                    return setup;
                }
                ++i;
            }
        }
        catch (Exception e) {
            LOGGER.log((IStatus)new Status(4, BUNDLE_ID, "Error in R setup: Failed to load setup.", (Throwable)e));
        }
        return null;
    }

    private static void loadSetupBase(String id, Map<String, String> filter, IConfigurationElement[] configurationElements, RSetup setup) throws Exception {
        IConfigurationElement element;
        int i = 0;
        while (i < configurationElements.length) {
            element = configurationElements[i];
            if (element.getName().equals(BASE_ELEMENT_NAME) && id.equals(element.getAttribute(SETUP_ID_ATTRIBUTE_NAME))) {
                String path = RSetupUtil.getLocation(element, filter);
                setup.setRHome(path);
                return;
            }
            ++i;
        }
        i = 0;
        while (i < configurationElements.length) {
            element = configurationElements[i];
            if (element.equals((Object)SETUP_ELEMENT_NAME) && id.equals(element.getAttribute(SETUP_ID_ATTRIBUTE_NAME))) {
                String inheritId = element.getAttribute(INHERIT_BASE_ATTRIBUTE_NAME);
                if (inheritId != null) {
                    RSetupUtil.loadSetupBase(inheritId, filter, configurationElements, setup);
                }
                return;
            }
            ++i;
        }
    }

    private static void loadSetupLibraries(String id, Map<String, String> filter, IConfigurationElement[] configurationElements, RSetup setup) throws Exception {
        int i = 0;
        while (i < configurationElements.length) {
            String path;
            IConfigurationElement element = configurationElements[i];
            if (element.getName().equals(LIBRARY_ELEMENT_NAME) && id.equals(element.getAttribute(SETUP_ID_ATTRIBUTE_NAME)) && (path = RSetupUtil.getLocation(element, filter)) != null) {
                String groupId = element.getAttribute(GROUP_ATTRIBUTE_NAME);
                if (groupId == null || groupId.isEmpty() || groupId.equals("R_LIBS")) {
                    setup.getRLibs().add(path);
                } else if (groupId.equals("R_LIBS_SITE")) {
                    setup.getRLibsSite().add(path);
                } else if (groupId.equals("R_LIBS_USER")) {
                    setup.getRLibsUser().add(path);
                } else {
                    RSetupUtil.log(2, "Invalid R setup element: Unknown library group '" + groupId + "', the library is ignored", element);
                }
            }
            ++i;
        }
    }

    private static String getLocation(IConfigurationElement element, Map<String, String> filter) throws Exception {
        Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
        String path = element.getAttribute(LOCATION_ATTRIBUTE_NAME);
        if (bundle != null && path != null && path.length() > 0) {
            URL[] bundleURLs = FileLocator.findEntries((Bundle)bundle, (IPath)new Path(path), filter);
            int i = 0;
            while (i < bundleURLs.length) {
                File file;
                URI fileURI = URIUtil.toURI((URL)FileLocator.toFileURL((URL)bundleURLs[i]));
                if (fileURI.getScheme().equals("file") && (file = new File(fileURI)).exists() && file.isDirectory() && file.list().length > 0) {
                    return file.getAbsolutePath();
                }
                ++i;
            }
        }
        return null;
    }

    private static void log(int severity, String message, IConfigurationElement element) {
        StringBuilder info = new StringBuilder(message);
        if (element != null) {
            info.append(" (contributed by '");
            info.append(element.getContributor().getName());
            info.append("').");
        }
        LOGGER.log((IStatus)new Status(2, BUNDLE_ID, info.toString()));
    }
}

