/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data;

import java.util.Map;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.DefaultRObjectFactory;

@NonNullByDefault
public class RDataJConverter {
    private boolean keepArray1;
    private RObjectFactory rObjectFactory;

    public RDataJConverter(RObjectFactory rObjectFactory) {
        this.rObjectFactory = (RObjectFactory)ObjectUtils.nonNullAssert((Object)rObjectFactory);
    }

    public RDataJConverter() {
        this(DefaultRObjectFactory.INSTANCE);
    }

    public void setKeepArray1(boolean enable) {
        this.keepArray1 = enable;
    }

    public void setRObjectFactory(RObjectFactory factory) {
        this.rObjectFactory = (RObjectFactory)ObjectUtils.nonNullAssert((Object)factory);
    }

    public RObjectFactory getRObjectFactory() {
        return this.rObjectFactory;
    }

    public @Nullable Object toJava(RObject rObject) {
        switch (rObject.getRObjectType()) {
            case 2: {
                return this.toJava((RStore)ObjectUtils.nonNullAssert(rObject.getData()));
            }
        }
        return null;
    }

    public @Nullable Object toJava(RStore<?> rData) {
        ?[] array = rData.toArray();
        if (!this.keepArray1 && array != null && array.length == 1) {
            return array[0];
        }
        return array;
    }

    public @Nullable RObject toRJ(@Nullable Object javaObj) {
        if (javaObj instanceof Boolean) {
            return this.rObjectFactory.createVector(this.rObjectFactory.createLogiData(new boolean[]{(Boolean)javaObj}));
        }
        if (javaObj instanceof String) {
            return this.rObjectFactory.createVector(this.rObjectFactory.createCharData(new String[]{(String)javaObj}));
        }
        if (javaObj instanceof String[]) {
            return this.rObjectFactory.createVector(this.rObjectFactory.createCharData((String[])javaObj));
        }
        if (javaObj instanceof Map) {
            Map map = (Map)javaObj;
            String[] names = new String[map.size()];
            RObject[] components = new RObject[map.size()];
            int i = 0;
            for (Map.Entry entry : map.entrySet()) {
                names[i] = (String)entry.getKey();
                components[i] = this.toRJ(entry.getValue());
                ++i;
            }
            return this.rObjectFactory.createList(components, names);
        }
        return null;
    }
}

