/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.rhelp;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RModel;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.rlang.RFrame;
import org.eclipse.statet.r.core.model.rlang.RSrcStrFrame;
import org.eclipse.statet.r.core.source.ast.FCall;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.rhelp.core.REnvHelp;
import org.eclipse.statet.rhelp.core.RHelpPage;
import org.eclipse.statet.rhelp.core.RHelpTopicLookup;
import org.eclipse.statet.rhelp.core.RPkgHelp;
import org.eclipse.statet.rj.renv.core.REnv;

@NonNullByDefault
public class RHelpLtkUI {
    public static final String INFO_TARGET = "info";

    public static REnvHelp getEnvHelp(@Nullable RSourceUnit sourceUnit) throws StatusException {
        RCoreAccess rCoreAccess = RCore.getContextAccess((IAdaptable)sourceUnit);
        REnv rEnv = rCoreAccess.getREnv();
        if (rEnv == null) {
            rEnv = RCore.getWorkbenchAccess().getREnv();
        }
        return RCore.getRHelpManager().getHelpChecked(rEnv);
    }

    public static @Nullable Object searchTopicObject1(REnvHelp help, String topic, @Nullable RAstNode covering, @Nullable RSourceUnit sourceUnit) throws CoreException {
        RHelpPage page;
        RHelpPage page2;
        RSrcStrFrame frame;
        if (covering != null && (frame = RModel.searchFrame((RAstNode)covering)) != null && (page2 = RHelpLtkUI.searchFrames(topic, RModel.createDirectFrameList((RFrame)frame), help)) != null) {
            return page2;
        }
        if (sourceUnit != null && (page = RHelpLtkUI.searchFrames(topic, RModel.createProjectFrameList(null, (RSourceUnit)sourceUnit), help)) != null) {
            return page;
        }
        return null;
    }

    public static @Nullable Object searchTopicObject2(REnvHelp help, String topic, ProgressMonitor m) throws StatusException {
        List pages = help.getPagesForTopic(topic, m);
        if (!pages.isEmpty()) {
            if (pages.size() == 1) {
                return pages.get(0);
            }
            return new RHelpTopicLookup(help.getREnv(), topic, ImCollections.toList((Collection)pages));
        }
        return null;
    }

    private static @Nullable RHelpPage searchFrames(String topic, @Nullable List<? extends RFrame<?>> frames, REnvHelp help) {
        if (frames == null) {
            return null;
        }
        for (RFrame<?> frame : frames) {
            RHelpPage page;
            RPkgHelp pkgHelp;
            if (frame.getFrameType() != 2 || (pkgHelp = help.getPkgHelp(frame.getElementName().getSegmentName())) == null || (page = pkgHelp.getPageForTopic(topic)) == null) continue;
            return page;
        }
        return null;
    }

    public static @Nullable RElementName searchName(@Nullable RAstNode node, TextRegion region, boolean checkInterrupted) {
        RAstNode node0 = node;
        int depth = 0;
        while (node0 != null && depth < 32) {
            if (checkInterrupted && Thread.currentThread().isInterrupted()) {
                return null;
            }
            ImList attachments = node0.getAttachments();
            for (Object attachment : attachments) {
                RElementName e;
                RElementAccess access;
                RSrcStrFrame frame;
                if (!(attachment instanceof RElementAccess) || ((frame = (access = (RElementAccess)attachment).getFrame()) == null || frame.getFrameType() == 5) && !RElementName.isPackageFacetScopeType((int)access.getType()) || (e = RHelpLtkUI.getElementAccessOfRegion(access, region)) == null) continue;
                return e;
            }
            node0 = node0.getRParent();
            ++depth;
        }
        return null;
    }

    public static @Nullable RElementName searchNameOfFunction(@Nullable RAstNode node, TextRegion region) {
        RAstNode node0 = node;
        while (node0 != null) {
            if (node0.getNodeType() == NodeType.F_CALL) {
                FCall fcall = (FCall)node0;
                if (fcall.getArgsOpenOffset() != Integer.MIN_VALUE && fcall.getArgsOpenOffset() <= region.getStartOffset()) {
                    ImList attachments = node0.getAttachments();
                    for (Object attachment : attachments) {
                        RElementName fName;
                        if (!(attachment instanceof RElementAccess)) continue;
                        RElementAccess access = (RElementAccess)attachment;
                        RSrcStrFrame frame = access.getFrame();
                        if (access.getNode() != fcall || frame == null || frame.getFrameType() == 5 || access.getNextSegment() != null || !RElementName.isRegularMainType((int)(fName = RElementName.normalize((RElementName)access)).getType())) continue;
                        return fName;
                    }
                }
                return null;
            }
            node0 = node0.getRParent();
        }
        return null;
    }

    private static @Nullable RElementName getElementAccessOfRegion(RElementAccess access, TextRegion region) {
        if (access.getSegmentName() == null) {
            return null;
        }
        int segmentCount = 0;
        RElementAccess segment0 = access;
        while (segment0 != null) {
            ++segmentCount;
            RAstNode nameNode = segment0.getNameNode();
            if (nameNode != null && nameNode.getStartOffset() <= region.getStartOffset() && nameNode.getEndOffset() >= region.getEndOffset()) {
                if (RElementName.isRegularMainType((int)access.getType())) {
                    return access;
                }
                if (RElementName.isPackageFacetScopeType((int)access.getType())) {
                    if (segmentCount == 1) {
                        return access;
                    }
                    if (RElementName.isRegularMainType((int)access.getNextSegment().getType()) && access.getNextSegment().getSegmentName() != null) {
                        return RElementName.normalize((RElementName)access);
                    }
                }
                return null;
            }
            segment0 = segment0.getNextSegment();
        }
        return null;
    }

    private RHelpLtkUI() {
    }
}

