/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import java.util.Objects;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.statet.ecommons.debug.core.model.IndexedValue;
import org.eclipse.statet.ecommons.debug.core.model.VariablePartitionFactory;
import org.eclipse.statet.internal.r.debug.core.model.BasicRElementVariable;
import org.eclipse.statet.internal.r.debug.core.model.RDebugTargetImpl;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariableValue;
import org.eclipse.statet.internal.r.debug.core.model.RIndexElementValue;
import org.eclipse.statet.internal.r.debug.core.model.RIndexValueInternal;
import org.eclipse.statet.internal.r.debug.core.model.RVectorIndexVariable;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.data.RValueFormatter;
import org.eclipse.statet.r.core.data.RValueValidator;
import org.eclipse.statet.r.debug.core.RVariable;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.RVector;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.services.FQRObjectRef;
import org.eclipse.statet.rj.services.RService;
import org.eclipse.statet.rj.services.util.dataaccess.LazyRStore;
import org.eclipse.statet.rj.services.util.dataaccess.RDataAssignment;
import org.eclipse.statet.rj.services.util.dataaccess.RVectorDataAdapter;
import org.eclipse.statet.rj.ts.core.RToolService;

@NonNullByDefault
public class RVectorValue
extends RElementVariableValue<CombinedRElement>
implements RIndexValueInternal {
    private static final RVectorDataAdapter ADAPTER = new RVectorDataAdapter();
    public static final int LOAD_SIZE = 1000;
    final long length;
    private @Nullable LazyRStore<RVector<?>> namesStore;
    private @Nullable LazyRStore<RVector<?>> dataStore;

    public RVectorValue(BasicRElementVariable variable) {
        super(variable);
        RVector<?> element = this.getRObject();
        this.length = element.getLength();
    }

    public final RVector<?> getRObject() {
        return (RVector)this.element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasValueChanged(long index) {
        LazyRStore.Fragment<RVector<?>> currentFragment;
        LazyRStore.Fragment<RVector<?>> previousFragment;
        RVectorValue previousValue;
        BasicRElementVariable basicRElementVariable = this.variable;
        synchronized (basicRElementVariable) {
            if (this != this.variable.getCurrentValue()) {
                return false;
            }
            previousValue = (RVectorValue)this.variable.getPreviousValue();
        }
        if (previousValue == null) return false;
        if (index >= previousValue.length) {
            return true;
        }
        RVectorValue rVectorValue = previousValue;
        synchronized (rVectorValue) {
            previousFragment = previousValue.getLoadedDataFragment(index);
            if (previousFragment == null) return false;
            if (previousFragment.getRObject() == null) {
                return false;
            }
        }
        rVectorValue = this;
        synchronized (rVectorValue) {
            currentFragment = this.getDataFragment(index);
            if (currentFragment == null) return false;
            if (currentFragment.getRObject() == null) {
                return false;
            }
        }
        if (!Objects.equals(((RVector)currentFragment.getRObject()).getData().get(currentFragment.toLocalRowIdx(index)), ((RVector)previousFragment.getRObject()).getData().get(previousFragment.toLocalRowIdx(index)))) return true;
        return false;
    }

    @Override
    public String getValueString() throws DebugException {
        if (this.length == 0L) {
            return "";
        }
        if (this.length == 1L) {
            String data = this.getDataExpr(0L);
            if (data == null) {
                throw this.newRequestLoadDataFailed();
            }
            return data;
        }
        return "[" + this.length + "]";
    }

    @Override
    public String getDetailString() {
        if (this.length == 0L) {
            return "";
        }
        if (this.length == 1L) {
            String data = this.getDataExpr(0L);
            if (data == null) {
                return "<error>";
            }
            return data;
        }
        return "";
    }

    @Override
    public boolean hasVariables() throws DebugException {
        return this.length > 1L;
    }

    @Override
    public @NonNull IVariable[] getVariables() throws DebugException {
        if (this.length <= 1L) {
            return NO_VARIABLES;
        }
        return this.getPartitionFactory().getVariables((IndexedValue)this);
    }

    @Override
    public VariablePartitionFactory<RIndexElementValue> getPartitionFactory() {
        return RElementVariableValue.PARTITION_FACTORY;
    }

    public long getSize() throws DebugException {
        return this.length;
    }

    public @NonNull RVariable[] getVariables(long offset, int length) {
        return this.getVariables(offset, length, this.variable);
    }

    @Override
    public @NonNull RVariable[] getVariables(long offset, int length, RVariable parent) {
        if (this.length <= 1L) {
            throw new UnsupportedOperationException();
        }
        if (offset < 0L || length < 0 || offset > this.length - (long)length) {
            throw new IllegalArgumentException();
        }
        RVariable[] variables = new RVariable[length];
        int i = 0;
        while (i < length) {
            variables[i] = new RVectorIndexVariable(this, offset + (long)i, parent);
            ++i;
        }
        return variables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected @Nullable String getName(long idx) {
        RValueFormatter formatter;
        LazyRStore.Fragment<RVector<?>> fragment;
        BasicRElementVariable basicRElementVariable = this.variable;
        synchronized (basicRElementVariable) {
            if (this != this.variable.getCurrentValue()) {
                return null;
            }
        }
        RVectorValue rVectorValue = this;
        synchronized (rVectorValue) {
            fragment = this.getNamesFragment(idx);
            if (fragment == null || fragment.getRObject() == null) {
                return null;
            }
        }
        RValueFormatter rValueFormatter = formatter = ((RDebugTargetImpl)this.getDebugTarget()).getValueFormatter();
        synchronized (rValueFormatter) {
            return formatter.formatName(((RVector)fragment.getRObject()).getNames(), (int)fragment.toLocalRowIdx(idx));
        }
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable LazyRStore.Fragment<RVector<?>> getNamesFragment(long idx) {
        if (this.namesStore == null) {
            this.namesStore = new LazyRStore(this.length, 1L, 100, (LazyRStore.Updater)new RElementVariableValue.RDataLoader<RVector<?>>(this){

                @Override
                protected RVector<?> doLoad(FQRObjectRef ref, LazyRStore.Fragment<RVector<?>> fragment, RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
                    return ADAPTER.loadRowNames(ref, RVectorValue.this.getRObject(), fragment, null, (RService)r, m);
                }
            });
        }
        return this.namesStore.getFragment(idx, 0L, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final @Nullable RStore<?> getValueType() {
        RStore data = this.element.getData();
        if (data.getStoreType() == 10) {
            RVectorValue rVectorValue = this;
            synchronized (rVectorValue) {
                LazyRStore.Fragment<RVector<?>> fragment;
                block5: {
                    fragment = this.getDataFragmentAny();
                    if (fragment != null && fragment.getRObject() != null) break block5;
                    return null;
                }
                data = ((RVector)fragment.getRObject()).getData();
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected @Nullable String getDataExpr(long idx) {
        RValueFormatter formatter;
        LazyRStore.Fragment<RVector<?>> fragment;
        BasicRElementVariable basicRElementVariable = this.variable;
        synchronized (basicRElementVariable) {
            if (this != this.variable.getCurrentValue()) {
                return null;
            }
        }
        RVectorValue rVectorValue = this;
        synchronized (rVectorValue) {
            fragment = this.getDataFragment(idx);
            if (fragment == null || fragment.getRObject() == null) {
                return null;
            }
        }
        RValueFormatter rValueFormatter = formatter = ((RDebugTargetImpl)this.getDebugTarget()).getValueFormatter();
        synchronized (rValueFormatter) {
            return formatter.format(((RVector)fragment.getRObject()).getData(), (int)fragment.toLocalRowIdx(idx));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean validateDataExpr(String expression) {
        RValueValidator validator;
        BasicRElementVariable basicRElementVariable = this.variable;
        synchronized (basicRElementVariable) {
            if (this != this.variable.getCurrentValue()) {
                return false;
            }
        }
        RStore<?> type = this.getValueType();
        RValueValidator rValueValidator = validator = ((RDebugTargetImpl)this.getDebugTarget()).getValueValidator();
        synchronized (rValueValidator) {
            return validator.isValid(type, expression);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDataExpr(long idx, String expression) throws DebugException {
        RStore data;
        RValueValidator validator;
        BasicRElementVariable basicRElementVariable = this.variable;
        synchronized (basicRElementVariable) {
            if (this != this.variable.getCurrentValue()) {
                throw this.newRequestSetDataFailed();
            }
        }
        RStore<?> type = this.getValueType();
        RValueValidator rValueValidator = validator = ((RDebugTargetImpl)this.getDebugTarget()).getValueValidator();
        synchronized (rValueValidator) {
            data = validator.toRData(type, expression);
        }
        if (data == null) {
            throw this.newNotSupported();
        }
        RDataAssignment assignment = new RDataAssignment(idx, 0L, data);
        RVectorValue rVectorValue = this;
        synchronized (rVectorValue) {
            this.setData(assignment);
        }
    }

    private LazyRStore<RVector<?>> ensureDataStore() {
        if (this.dataStore == null) {
            this.dataStore = new LazyRStore(this.length, 1L, 100, (LazyRStore.Updater)new RElementVariableValue.RDataLoader<RVector<?>>(this){

                @Override
                protected void doSet(FQRObjectRef ref, RDataAssignment assignment, RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
                    ADAPTER.setData(ref, RVectorValue.this.getRObject(), assignment, null, (RService)r, m);
                }

                @Override
                protected RVector<?> doLoad(FQRObjectRef ref, LazyRStore.Fragment<RVector<?>> fragment, RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
                    return (RVector)ADAPTER.loadData(ref, RVectorValue.this.getRObject(), fragment, null, (RService)r, m);
                }
            });
        }
        return this.dataStore;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable LazyRStore.Fragment<RVector<?>> getDataFragment(long idx) {
        return this.ensureDataStore().getFragment(idx, 0L, 0, null);
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable LazyRStore.Fragment<RVector<?>> getDataFragmentAny() {
        LazyRStore<RVector<?>> dataStore = this.ensureDataStore();
        LazyRStore.Fragment fragment = dataStore.getLoadedFragmentAny();
        if (fragment == null) {
            fragment = dataStore.getLoadedFragment(0L, 0L);
        }
        return fragment;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable LazyRStore.Fragment<RVector<?>> getLoadedDataFragment(long idx) {
        return this.dataStore != null ? this.dataStore.getLoadedFragment(idx, 0L) : null;
    }

    public void setData(RDataAssignment assignment) {
        this.ensureDataStore().set(assignment, 0, null);
        this.variable.fireChangeEvent(512);
    }
}

