/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.pkgmanager;

import java.util.Collection;
import java.util.Objects;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.r.core.pkgmanager.RPkgUtils;
import org.eclipse.statet.r.core.pkgmanager.RRepo;
import org.eclipse.statet.r.core.pkgmanager.RRepoSettings;

@NonNullByDefault
public class BasicRRepoSettings
implements RRepoSettings {
    private final ImList<RRepo> repos;
    private final @Nullable RRepo cranMirror;
    private final @Nullable String biocVersion;
    private final @Nullable RRepo biocMirror;

    public BasicRRepoSettings(ImList<RRepo> repos, @Nullable RRepo cranMirror, @Nullable String bioCVersion, @Nullable RRepo bioCMirror) {
        this.repos = (ImList)ObjectUtils.nonNullAssert(repos);
        this.cranMirror = cranMirror;
        this.biocVersion = bioCVersion;
        this.biocMirror = bioCMirror;
    }

    public BasicRRepoSettings(Collection<RRepo> repos, @Nullable RRepo cranMirror, @Nullable String bioCVersion, @Nullable RRepo bioCMirror) {
        this.repos = ImCollections.toList(repos);
        this.cranMirror = cranMirror;
        this.biocVersion = bioCVersion;
        this.biocMirror = bioCMirror;
    }

    @Override
    public ImList<RRepo> getRepos() {
        return this.repos;
    }

    @Override
    public @Nullable RRepo getRepo(String repoId) {
        if (repoId == "special-ws-cache-source") {
            return RRepo.WS_CACHE_SOURCE_REPO;
        }
        if (repoId == "special-ws-cache-binary") {
            return RRepo.WS_CACHE_BINARY_REPO;
        }
        return RPkgUtils.getRepoById(this.repos, repoId);
    }

    @Override
    public @Nullable RRepo getCRANMirror() {
        return this.cranMirror;
    }

    @Override
    public @Nullable String getBioCVersion() {
        return this.biocVersion;
    }

    @Override
    public @Nullable RRepo getBioCMirror() {
        return this.biocMirror;
    }

    public int hashCode() {
        int h = this.repos.hashCode();
        h = h * 31 + Objects.hashCode(this.cranMirror);
        h = h * 31 + Objects.hashCode(this.biocVersion);
        h = h * 31 + Objects.hashCode(this.biocMirror);
        return h;
    }

    public boolean equals(@Nullable Object obj) {
        RRepoSettings other;
        return this == obj || obj instanceof RRepoSettings && this.repos.equals((other = (RRepoSettings)obj).getRepos()) && Objects.equals(this.cranMirror, other.getCRANMirror()) && Objects.equals(this.biocVersion, other.getBioCVersion()) && Objects.equals(this.biocMirror, other.getBioCMirror());
    }
}

